<script>
	jQuery('body').on('click', '.btn-remove-dstb', function() {
		var id = jQuery(this).attr('data-id');
		show_loading();
		jQuery.ajax({
		    url: app_url + 'dstb_process/remove_list',
		    type: 'POST',
		    dataType: 'JSON',
		    data: {
		    	id: id
		    },
		    success: function(response) {
		        hide_loading();
		        if (response.err_code == 0) {
		            location.reload();
		        }
		        else {
		            bootbox.alert(response.err_message);
		        }
		    },
		    error: function(res){}
		});      
	});

	jQuery('body').on('click', '.btn-go-data', function() {
		scan_data();
	});

	function scan_data() {
		show_loading();
		jQuery.ajax({
		    url: app_url + 'dstb_process/scan_data',
		    type: 'POST',
		    dataType: 'JSON',
		    data: {
		    	code: jQuery("#inp_code").val(),
		    	type: jQuery('#hd_type').val()
		    },
		    success: function(response) {
		        hide_loading();
		        if (response.err_code == 0) {
		            location.reload();
		        }
		        else {
		            bootbox.alert(response.err_message);
		        }
		    },
		    error: function(res){}
		});		
	}


	let scanner = new Instascan.Scanner({ video: document.getElementById('scanner'), mirror: false });
        scanner.addListener('scan', function (content) {

        if (content != 'null') {
            jQuery('.container-scanner').addClass('hide');
            
            jQuery("#inp_code").val(content);
            scan_data();

            scanner.stop();            
        }
    });

    jQuery('body').on('click', '#btn_scan', function(es) {
        es.stopPropagation();

        Instascan.Camera.getCameras().then(function (cameras) {
            if (cameras.length > 0) {
                if(cameras[1]){ 
                    scanner.start(cameras[1]); 
                } 
                else { 
                    scanner.start(cameras[0]); 
                }
                // scanner.start(cameras[0]);
            } else {
                console.error('No cameras found.');
            }
        }).catch(function (e) {
            console.error(e);
        });         

        jQuery('.container-scanner').removeClass('hide');
    });

    jQuery('body').on('click', '.btn-close-scanner', function() {
        scanner.stop();
        jQuery('.container-scanner').addClass('hide');
    });

    jQuery('body').on('click', '#btn_verif_driver', function() {
    	show_loading();
    	jQuery.ajax({
    	    url: app_url + 'dstb_process/verif_driver',
    	    type: 'POST',
    	    dataType: 'JSON',
    	    data: {
    	    	id: jQuery('#hd_iddstb').val()
    	    },
    	    success: function(response) {
    	        hide_loading();
    	        if (response.err_code == 0) {
    	            bootbox.alert({
    	            	message: "Verifikasi Berhasil",
    	            	callback: function(cal) {
    	            		location.href = app_url + 'dstb_process';
    	            	}
    	            });
    	        }
    	        else {
    	            bootbox.alert(response.err_message);
    	        }
    	    },
    	    error: function(res){}
    	});
    	      
    });