<!DOCTYPE html>
<html>
<head>
	<title>DSTB Barang Jadi</title>
	<style type="text/css">
		.tr-active {
			background-color: #cfe9ff;
		}
		body {
/*			width: 10.5cm;*/
			width: 8cm;
			font-family: 'Arial';
			font-size: 12px;
		}

		@media print {
			body {
				width: auto;
			}
		}
	</style>
</head>
<body onload="window.print();">

	<table>
		<tr>
			<td>
				<img style="display:inline-block" src="https://quickchart.io/qr?size=150&text=<?php echo $data->row()->dstb_code;?>">
			</td>
			<td>
				<div>DSTB PROSES <?php echo $data->row()->outlet_name;?></div>
				<table cellspacing="0">
					<tr>
						<td>Tgl</td>
						<td align="center" width="10px">:</td>
						<td><?php echo Date('d-m-Y', strtotime($data->row()->dstb_date));?></td>
					</tr>
					<tr>
						<td>No</td>
						<td align="center">:</td>
						<td><?php echo $data->row()->dstb_number;?></td>
					</tr>
					<tr>
						<td colspan="3"><?php echo $data->row()->dstb_code;?></td>
					</tr>
					<tr>
						<td>Kasir</td>
						<td align="center">:</td>
						<td><?php echo $data->row()->cashier_name;?></td>
					</tr>
					<tr>
						<td>Driver</td>
						<td align="center">:</td>
						<td><?php echo $data->row()->driver_name;?></td>
					</tr>
					<tr>
						<td>Produksi</td>
						<td align="center">:</td>
						<td><?php echo $data->row()->production_name;?></td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="2">
				<table width="100%">
					<tr>
						<td align="center">Total Bill: <?php echo $data->row()->total_bill;?></td>
						<td align="center">Total Pcs: <?php echo $data->row()->total_pcs_dstb;?></td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
	<hr>


	<table border="1" width="100%" style="border-collapse: collapse;" cellpadding="2" cellspacing="2">
		<tr>
			<th>No Bill</th>
			<th>Nama</th>
			<th>Jml</th>
			<th>Tgl Masuk</th>
			<th>Tgl Selesai</th>
			<th>Catatan</th>
		</tr>
		<?php 
			foreach ($data->result() as $key => $value) {
				$tr_class = '';
				if ($value->dstb_status == 'DIJEMPUT' && $page_type == 'driver') {
					$tr_class = 'tr-active';
				}
		?>
		<tr class="<?php echo $tr_class;?>">
			<td><?php echo $value->code;?></td>
			<td><?php echo $value->customer_name;?></td>
			<td align="center"><?php echo $value->total_pcs;?></td>
			<td align="center"><?php echo Date('d-m-Y', strtotime($value->date));?></td>
			<td align="center"><?php echo Date('d-m-Y', strtotime($value->duedate));?></td>
			<td><?php echo $value->note;?></td>
		</tr>
		<?php
			}
		?>
	</table>
	<div style="margin-top:10px;">
		Catatan DSTB: <?php echo $data->row()->dstb_note;?>
	</div>
	<div style="margin-top:10px;font-size:11px;">
		Dicetak pada <?php echo Date('d-m-Y H:i:s');?>
	</div>
	<div style="margin-top: 20px;">
		<table width="100%">
			<tr>
				<td align="center" width="33.33%">(Kasir)</td>
				<td align="center" width="33.33%">(Produksi)</td>
				<td align="center">(Supir)</td>
			</tr>	
		</table>
	</div>
</body>
</html>