<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class St_process extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('st_process');

        $this->table = 'st_process';
        $this->load->helper('az_crud');
        $this->load->library('AZApp');
        $this->crud = $this->azapp->add_crud();
    }

	public function index(){
		$azapp = $this->azapp;
		
		$data_header['title'] = 'ST Proses';
		$data_header['breadcrumb'] = array('st_process');
		$azapp->set_data_header($data_header);

		$view = $this->load->view('st_process/v_st_process', '', true);
		$azapp->add_content($view);

		$this->load->helper('az_core');

		$azapp->add_content("<div class='container-scanner hide'><button class='btn btn-danger btn-sm btn-close-scanner' type='button'>".azlang('Close')."</button><br><video class='scanner' id='scanner'></video></div>");

		$param['type'] = 'st_process';
		$js = az_add_js('js/vjs_act_scanner', $param);
		$azapp->add_js($js);

		$js = az_add_js('st_process/vjs_st_process');
		$azapp->add_js($js);
		
		echo $azapp->render();	
	}

	function get_data() {
		$code = $this->input->post('code');
		$err_code = 0;
		$err_message = '';
		$view = '';
		$idrole = $this->session->userdata('idrole');

		if (strlen($code) == 0) {
			$err_code++;
			$err_message = 'Harap isi Kode Bill';
		}

		if ($err_code == 0) {
			if ($idrole == 3) {
				$this->db->where('code', $code);
				$this->db->where('iddriver', $this->session->userdata('iduser'));
				$check = $this->db->get('transaction_group');

				if ($check->num_rows() == 0) {
					$err_code++;
					$err_message = 'Data tidak ditemukan';
				}
			}
		}

		if ($err_code == 0) {
			$this->load->library('Laundry');
			$rdata = $this->laundry->invoice($code);

			$err_code = azarr($rdata, 'err_code');
			$err_message = azarr($rdata, 'err_message');
		}

		if ($err_code == 0) {
			$rdata['html'] = false;
			$this->db->where('status', 1);
			$this->db->where('idrole', 3);
			$rdata['driver'] = $this->db->get('user');

			$view = $this->load->view('sales_transaction/v_invoice_production', $rdata, true);
			$view .= $this->load->view('st_process/v_tmp_st_process', $rdata, true);
		}


		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message,
			'data' => $view
		);
		echo json_encode($return);
	}

	function save() {
		$err_code = 0;
		$err_message = '';
		$id = $this->input->post('id');
		$iddriver = $this->input->post('iddriver');

		$this->db->where('idtransaction_group', $id);
		$trx = $this->db->get('transaction_group');

		$arr = array();
		if ($trx->row()->transaction_group_status == 'Baru') {
			if (strlen($iddriver) == 0) {
				$err_code++;
				$err_message = 'Harap pilih driver';
			}

			if ($err_code == 0) {
				$arr['iddriver'] = $iddriver;
			}
		}
		else {
			$arr['process_status'] = $this->input->post('process_status');
		}

		if ($err_code == 0) {
			az_crud_save($id, 'transaction_group', $arr);
		}

		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message
		);
		echo json_encode($return);
	}

	function approve_bill() {
		$err_code = 0;
		$err_message = '';
		$id = $this->input->post('id');
		
		$idrole = $this->session->userdata('idrole');

		if (strlen($id) == 0) {
			$err_code++;
			$err_message = 'ID not valid';
		}

		if ($idrole != '3') {
			$err_code++;
			$err_message = 'Akses ditolak';
		}

		if ($err_code == 0) {
			$arr = array(
				'transaction_group_status' => 'St Proses',
				'process_status' => 'Penjemputan'
			);
			az_crud_save($id, 'transaction_group', $arr);
		}

		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message
		);
		echo json_encode($return);
	}

	function approve_production() {
		$err_code = 0;
		$err_message = '';
		$id = $this->input->post('id');
		
		$idrole = $this->session->userdata('idrole');

		if (strlen($id) == 0) {
			$err_code++;
			$err_message = 'ID not valid';
		}

		if ($idrole != '4') {
			$err_code++;
			$err_message = 'Akses ditolak';
		}

		if ($err_code == 0) {
			$arr = array(
				'idproduction' => $this->session->userdata("idproduction"),
				'process_status' => 'Produksi'
			);
			az_crud_save($id, 'transaction_group', $arr);
		}

		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message
		);
		echo json_encode($return);
	}
}