<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class History_bill_production extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('history_bill_production');
        $this->table = 'dstb_process_detail';
        $this->controller = 'history_bill_production';
        $this->load->helper('az_crud');
        $this->load->helper('az_config');
    }

    function index() {
    	$this->load->library('AZApp');
    	$app = $this->azapp;

    	$crud = $app->add_crud();

		$crud->set_column(array('#', azlang('Outlet'), azlang('Status'), azlang('Invoice Code'),  azlang('Customer'), azlang('Date'), 'Tgl Selesai', 'Keterangan Bill', azlang('Action')));
		$crud->set_id($this->controller);
		$crud->set_default_url(true);
		$crud->set_single_filter(false);

		$datetime1 = $app->add_datetime();
		$datetime1->set_id("date_1");
		$datetime1->set_name("date_1");
		$datetime1->set_value('01'.Date("-m-Y"));
		$datetime1->set_format("DD-MM-YYYY");
		$datetime1->add_class("con-element-top-filter");
		$datetime1 = $datetime1->render();

		$datetime2 = $app->add_datetime();
		$datetime2->set_id("date_2");
		$datetime2->set_name("date_2");
		$datetime2->set_value(Date("d-m-Y",  strtotime("last day of this month")));
		$datetime2->set_format("DD-MM-YYYY");
		$datetime2->add_class("con-element-top-filter");
		$datetime2 = $datetime2->render();

        $outlet = az_select_outlet('outlet', 'transaction_group');

        $data['datetime1'] = $datetime1;
        $data['datetime2'] = $datetime2;
        $data['outlet'] = $outlet;

        $v_filter = $this->load->view("history_bill_production/v_history_bill_production_top_filter", $data, true);

        $crud->set_btn_add(false);
        $crud->set_top_filter($v_filter);
		$crud = $crud->render();
		$app->add_content($crud);	

		$js = az_add_js('history_bill_production/vjs_history_bill_production');
		$app->add_js($js);


    	$data_header['title'] = 'History Bill Produksi';
		$data_header['breadcrumb'] = array('history_bill_production');
		$app->set_data_header($data_header);
    	echo $app->render();
    }

    public function get() {
		$this->load->library('AZApp');
		$crud = $this->azapp->add_crud();

		$idrole = $this->session->userdata('idrole');
		$crud->set_select("dstb_process_detail.iddstb_process_detail, dstb_process_detail.iddstb_process, outlet_name, dstb_status, code, customer_name, date_format(date, '%d-%m-%Y %H:%i:%s') as date, date_format(duedate, '%d-%m-%Y %H:%i:%s') as duedate, dstb_note, dstb_process_detail.idtransaction_group, pending_description");
		$crud->set_select_table("iddstb_process_detail, outlet_name, dstb_status, code, customer_name, date, duedate, dstb_note");
		$crud->set_sorting('outlet_name, dstb_status, code, customer_name, date, duedate, dstb_note');
		$crud->set_id($this->controller);
		$sess_idoutlet = $this->session->userdata('idoutlet');
		if (strlen($sess_idoutlet) > 0) {
			$crud->add_where('transaction_group.idoutlet = '. $sess_idoutlet);
		}
		$crud->add_where('dstb_status != "BARU"');
		if (!in_array($idrole, array('', '1'))) {
			$crud->add_where('((dstb_status not in ("SELESAI", "END PROCESS")) or (dstb_status = "END PROCESS" and date(date) > (NOW() - INTERVAL 2 WEEK)))');
		}
		$crud->set_group_by('transaction_group.idtransaction_group');
		$crud->add_join_manual('transaction_group', 'dstb_process_detail.idtransaction_group = transaction_group.idtransaction_group');
		$crud->add_join_manual('dstb_process', 'dstb_process_detail.iddstb_process = dstb_process.iddstb_process');
		$crud->add_join_manual('customer', 'transaction_group.idcustomer = customer.idcustomer', 'left');
		$crud->add_join_manual('outlet', 'transaction_group.idoutlet = outlet.idoutlet');
		$crud->add_where("dstb_process_detail.status > 0");
		$crud->add_where("transaction_group.status > 0");
		$crud->add_where('dstb_process.idproduction is not null');
		$crud->set_table($this->table);
		$crud->set_order_by("transaction_group.created desc");
		$crud->set_custom_style('custom_style');
		echo $crud->get_table();
	}

	function custom_style($key, $value, $data) {
		$idtrx_group = azarr($data, 'idtransaction_group');
		if ($key == 'action') {
			$id = azarr($data, 'iddstb_process');
			$btn = "<a href='".app_url()."history_bill_production/print_data/".az_encode_url($id)."' target='_blank'><button class='btn btn-default btn-xs' type='button'><i class='fa fa-print'></i> Print DSTB</button></a>";
			$btn .= "<a href='".app_url()."history_bill_production/print_bill_production/".az_encode_url($idtrx_group)."' target='_blank'><button class='btn btn-info btn-xs' type='button'><i class='fa fa-print'></i> Print Bill Produksi</button></a>";

			return $btn;
		}
		else if ($key == 'dstb_status') {
			$lbl = '';
			$duedate = azarr($data, 'duedate');
			$dstb_status = azarr($data, 'dstb_status');
			$pending_description = azarr($data, 'pending_description', '-');
			if ($dstb_status == 'DIPROSES' && strtotime($duedate) < strtotime(Date('Y-m-d H:i:s'))) {
				$lbl = "<br><button class='btn btn-danger btn-xs btn-pending-description' type='button' data-id='".$idtrx_group."'><i class='fa fa-list'></i> Pending</button>";

				$this->db->where('idtransaction_group', $idtrx_group);
				$this->db->where('status', 1);
				$check = $this->db->get('dstb_clean_detail');
				if ($check->num_rows() > 0) {
					$lbl = '';
				}
			}

			return $value.$lbl;
		}
		return $value;
	}

	function get_pending_description() {
	    $err_code = 0;
	    $err_message = '';
	
	    $id = $this->input->post("id");
	    $this->db->where('idtransaction_group', $id);
	    $data = $this->db->get('transaction_group');

	    $res = '';
	    if ($data->num_rows() > 0) {
	    	$res = $data->row()->pending_description;
	    }
	
	    $return = array(
	        'err_code' => $err_code,
	        'err_message' => $err_message,
	        'data' => $res
	    );
	
	    echo json_encode($return);
	}
	      

	function print_data($id) {
		$data['page_type'] = 'administrator';

		$data['data'] = $this->get_db_detail($id);

		$this->load->view('dstb_process/v_print_dstb_detail', $data);
	}

	private function get_db_detail($id) {
		$id = az_decode_url($id);
		$this->db->where('dstb_process_detail.iddstb_process', $id);
		$this->db->join('transaction_group', 'dstb_process_detail.idtransaction_group = transaction_group.idtransaction_group');
		$this->db->join('outlet', 'transaction_group.idoutlet = outlet.idoutlet');
		$this->db->join('customer', 'transaction_group.idcustomer = customer.idcustomer');
		$this->db->join('dstb_process', 'dstb_process_detail.iddstb_process = dstb_process.iddstb_process');
		$this->db->join('user cashier', 'dstb_process.idcashier = cashier.iduser', 'left');
		$this->db->join('user driver', 'dstb_process.iddriver = driver.iduser', 'left');
		$this->db->join('user production', 'dstb_process.idproduction = production.iduser', 'left');		
		$this->db->select('*, cashier.name as cashier_name, driver.name as driver_name, production.name as production_name, dstb_process.total_pcs as total_pcs_dstb, transaction_group.total_pcs');
		$data = $this->db->get('dstb_process_detail');

		return $data;
	}

	function print_bill_production($id) {
		$id = az_decode_url($id);
		$this->load->helper('az_core');
		$this->load->library('Laundry');
		$data = $this->laundry->invoice('x', $id);
		

		$this->load->view('sales_transaction/v_bill_production', $data);
	}
}