<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Entry_photo extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('entry_photo');

        $this->table = 'entry_photo';
        $this->load->helper('az_crud');
        $this->load->library('AZApp');
        $this->crud = $this->azapp->add_crud();
    }

	public function index(){
		$azapp = $this->azapp;
		
		$data_header['title'] = 'Entry Foto';
		$data_header['breadcrumb'] = array('entry_photo');
		$azapp->set_data_header($data_header);

		$view = $this->load->view('entry_photo/v_entry_photo', '', true);
		$azapp->add_content($view);

		$this->load->helper('az_core');

		$azapp->add_content("<div class='container-scanner hide'><button class='btn btn-danger btn-sm btn-close-scanner' type='button'>".azlang('Close')."</button><br><video class='scanner' id='scanner'></video></div>");

		$param['type'] = 'entry_photo';
		$js = az_add_js('js/vjs_act_scanner', $param);
		$azapp->add_js($js);

		$js = az_add_js('entry_photo/vjs_entry_photo');
		$azapp->add_js($js);
		
		echo $azapp->render();	
	}

	function get_data() {
		$code = $this->input->post('code');
		$err_code = 0;
		$err_message = '';
		$view = '';

		if (strlen($code) == 0) {
			$err_code++;
			$err_message = 'Harap isi Kode Baju';
		}

		if ($err_code == 0) {
			$this->db->where('item_code', $code);
			$this->db->join('customer', 'item.idcustomer = customer.idcustomer');
			$this->db->join('product', 'item.idproduct = product.idproduct');
			$data_item = $this->db->get('item');

			if ($data_item->num_rows() == 0) {
				$err_code++;
				$err_message = 'Data tidak ditemukan';
			}
		}

		if ($err_code == 0) {
			
			$this->load->library('AZApp');
			$azapp = $this->azapp;
			$def_img = base_url().AZAPP.'assets/images/no-image.jpg';
			$img1 = $def_img;
			$img2 = $def_img;
			$img3 = $def_img;
			$img4 = $def_img;
			$img5 = $def_img;
			$img6 = $def_img;

			if (strlen($data_item->row()->photo1) > 0) {
				$img1 = base_url().AZAPP.'assets/item/'.$data_item->row()->photo1;
			}
			if (strlen($data_item->row()->photo2) > 0) {
				$img2 = base_url().AZAPP.'assets/item/'.$data_item->row()->photo2;
			}
			if (strlen($data_item->row()->photo3) > 0) {
				$img3 = base_url().AZAPP.'assets/item/'.$data_item->row()->photo3;
			}
			if (strlen($data_item->row()->photo4) > 0) {
				$img4 = base_url().AZAPP.'assets/item/'.$data_item->row()->photo4;
			}
			if (strlen($data_item->row()->photo5) > 0) {
				$img5 = base_url().AZAPP.'assets/item/'.$data_item->row()->photo5;
			}
			if (strlen($data_item->row()->photo6) > 0) {
				$img6 = base_url().AZAPP.'assets/item/'.$data_item->row()->photo6;
			}


			$image = $azapp->add_image();
			$image->set_id('image1');
			$image->set_image_width("200px");
			$image->set_image_height("150px");
			$image->set_image_url($img1);
			$data["image1"] = $image->render();

			$image = $azapp->add_image();
			$image->set_id('image2');
			$image->set_image_width("200px");
			$image->set_image_height("150px");
			$image->set_image_url($img2);
			$data["image2"] = $image->render();

			$image = $azapp->add_image();
			$image->set_id('image3');
			$image->set_image_width("200px");
			$image->set_image_height("150px");
			$image->set_image_url($img3);
			$data["image3"] = $image->render();

			$image = $azapp->add_image();
			$image->set_id('image4');
			$image->set_image_width("200px");
			$image->set_image_height("150px");
			$image->set_image_url($img4);
			$data["image4"] = $image->render();

			$image = $azapp->add_image();
			$image->set_id('image5');
			$image->set_image_width("200px");
			$image->set_image_height("150px");
			$image->set_image_url($img5);
			$data["image5"] = $image->render();

			$image = $azapp->add_image();
			$image->set_id('image6');
			$image->set_image_width("200px");
			$image->set_image_height("150px");
			$image->set_image_url($img6);
			$data["image6"] = $image->render();

			

			$colour = '';
			$hue = '';
			if ($data_item->num_rows() > 0) {
				$colour = az_convert_colour($data_item->row()->idcolour);
				$hue = az_convert_hue($data_item->row()->idhue);
			}

			$arr_data = array(
				'iditem' => $data_item->row()->iditem,
				'item_code' => $data_item->row()->item_code,
				'product_name' => $data_item->row()->product_name,
				'product_name' => $data_item->row()->product_name,
				'customer_name' => $data_item->row()->customer_name,
				'colour' => $colour,
				'hue' => $hue,
			);

			$data = array_merge($data, $arr_data);

			$view = $this->load->view('entry_photo/v_tmp_entry_photo', $data, true);
		}


		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message,
			'data' => $view
		);
		echo json_encode($return);
	}

	function save() {
		$err_code = 0;
		$err_message = '';
		$insert_id = $this->input->post('id');

		for ($i=1; $i <= 6; $i++) { 
			if(isset($_FILES['image'.$i]['tmp_name'])){
				$config['upload_path'] = APPPATH.'/assets/item/';
				$config['allowed_types'] = 'gif|jpg|png';
				$config['overwrite'] = false;
				$config['max_size']	= '30000';
				$config['encrypt_name'] = true;

				$this->load->library('upload', $config);

				$new_name = time().$insert_id.'-'.$_FILES['image'.$i]['name'];
				$config['file_name'] = $new_name;
				$this->upload->initialize($config);
				if (!$this->upload->do_upload('image'.$i)){
					$err_code++;
					$err_message = $this->upload->display_errors();
				}
				else {
					$data = array('upload_data' => $this->upload->data());
					$db_filename = azarr($this->upload->data(), 'file_name');

					$this->resizeImage($db_filename);

					$data_update['photo'.$i] = $db_filename;
					$this->db->where('iditem', $insert_id);
					$this->db->update('item', $data_update);
				}
				
			}
		}

		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message
		);
		echo json_encode($return);
	}

	public function resizeImage($filename) {
		$err_message = '';
		$err_code = 0;

		$source_path = APPPATH. 'assets/item/' . $filename;
		$target_path = APPPATH. 'assets/item/';
		$config_manip = array(
		  'image_library' => 'gd2',
		  'source_image' => $source_path,
		  'new_image' => $target_path,
		  'maintain_ratio' => TRUE,
		  'width' => 500,
		);
   
		$this->load->library('image_lib', $config_manip);
		if (!$this->image_lib->resize()) {
			$err_code++;
			$err_message = $this->image_lib->display_errors();
		}
		$this->image_lib->clear();

		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message
		);

		return $return;
   }

	
}