<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dpt_report extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('dpt_report');

        $this->load->helper('az_crud');
        $this->load->library('AZApp');
        $this->crud = $this->azapp->add_crud();
    }

	public function index(){
		$azapp = $this->azapp;
		$data_header['title'] = "Laporan DPT";
		$data_header['breadcrumb'] = array('report', 'dpt_report');
		$azapp->set_data_header($data_header);

		$datetime1 = $azapp->add_datetime();
		$datetime1->set_id("date_1");
		$datetime1->set_name("date_1");
		$datetime1->set_value(Date("d-m-Y"));
		$datetime1->set_format("DD-MM-YYYY");
		$data['datetime1'] = $datetime1->render();

		$datetime2 = $azapp->add_datetime();
		$datetime2->set_id("date_2");
		$datetime2->set_name("date_2");
		$datetime2->set_value(Date("d-m-Y"));
		$datetime2->set_format("DD-MM-YYYY");
		$data['datetime2'] = $datetime2->render();

		$this->load->helper('az_core');
		$js = az_add_js('dpt_report/vjs_dpt_report');
		$azapp->add_js($js);

		$view = $this->load->view('dpt_report/v_dpt_report', $data, true);
		$azapp->add_content($view);
		
		echo $azapp->render();	
	}

	function get_dpt() {
		$this->load->helper('az_core');
		$date_1 = $this->input->post('date_1');
		$date_2 = $this->input->post('date_2');

		$date_1 = Date('Y-m-d', strtotime($date_1));
		$date_2 = Date('Y-m-d', strtotime($date_2));

		$idcashier = $this->input->post("idcashier");
		
		$idoutlet = $this->input->post('idoutlet');
		$sess_idoutlet = $this->session->userdata('idoutlet');
		if (strlen($sess_idoutlet) > 0) {
			$idoutlet = $sess_idoutlet;
		}

		if (strlen($idoutlet) > 0) {
			$this->db->where('transaction_group.idoutlet', $idoutlet);
		}
		if (strlen($idcashier) > 0) {
			$this->db->where('transaction_group.iduser', $idcashier);
		}
		$this->db->where('date(date) >=', $date_1);
		$this->db->where('date(date) <=', $date_2);
		$this->db->where_in('payment_status', array('PANJAR', 'CASH'));
		$this->db->join('customer', 'transaction_group.idcustomer = customer.idcustomer');
		$this->db->join('user', 'transaction_group.iduser = user.iduser');
		$trx = $this->db->get('transaction_group');

		$arr = array();
		$grand_total = 0;
		foreach ($trx->result() as $key => $value) {
			$total_pay = $value->grand_total_final;
			if ($value->payment_status == 'PANJAR') {
				$total_pay = $value->total_panjar;
			}
			$arr[] = array(
				'nobill' => $value->code,
				'date' => $value->date,
				'customer' => $value->customer_name,
				'grand_total_final' => $value->grand_total_final,
				'total_pay' => $total_pay,
				'cashier' => $value->name,
				'status' => $value->transaction_group_status,
				'payment_status' => $value->payment_status
			);

			$grand_total += $total_pay;
		}

		// ==================
		$table_payment = '';

		if (strlen($idoutlet) > 0) {
			$this->db->where('transaction_group.idoutlet', $idoutlet);
		}
		if (strlen($idcashier) > 0) {
			$this->db->where('transaction_group.iduser', $idcashier);
		}
		$this->db->where('date(date) >=', $date_1);
		$this->db->where('date(date) <=', $date_2);
		$this->db->where_in('payment_status', array('PANJAR', 'CASH'));
		$this->db->where('transaction_group.status', 1);
		$this->db->join('payment_type', 'transaction_group.idpayment_type = payment_type.idpayment_type');
		$this->db->join('customer', 'transaction_group.idcustomer = customer.idcustomer');
		$this->db->order_by('transaction_group.idpayment_type');
		$data_payment = $this->db->get('transaction_group');


		if (strlen($idoutlet) > 0) {
			$this->db->where('idoutlet', $idoutlet);
		}
		if (strlen($idcashier) > 0) {
			$this->db->where('iduser', $idcashier);
		}
		$this->db->where('date(datetime) >=', $date_1);
		$this->db->where('date(datetime) <=', $date_2);
		$this->db->join('outlay_type', 'outlay.idoutlay_type = outlay_type.idoutlay_type');
		$rdata_payment['outlay'] = $this->db->get('outlay');

		$rdata_payment['data'] = $data_payment;
		$table_payment = $this->load->view('dpt_report/v_table_payment', $rdata_payment, true);

		$result = array(
			'data' => $arr,
			'total' => $grand_total,
			'table_payment' => $table_payment,
		);

		echo json_encode($result);
	
	}
}