<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dpt_report extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('dpt_report');

        $this->load->helper('az_crud');
        $this->load->library('AZApp');
        $this->crud = $this->azapp->add_crud();
    }

	public function index(){
		$azapp = $this->azapp;
		$data_header['title'] = "Laporan DPT";
		$data_header['breadcrumb'] = array('report', 'dpt_report');
		$azapp->set_data_header($data_header);

		$datetime1 = $azapp->add_datetime();
		$datetime1->set_id("date_1");
		$datetime1->set_name("date_1");
		$datetime1->set_value(Date("d-m-Y"));
		$datetime1->set_format("DD-MM-YYYY");
		if ($this->session->userdata('role_name') == 'cashier') {
			$datetime1->set_min_date(Date('Y-m-d', strtotime('-5 day')));
		}
		$data['datetime1'] = $datetime1->render();

		$datetime2 = $azapp->add_datetime();
		$datetime2->set_id("date_2");
		$datetime2->set_name("date_2");
		$datetime2->set_value(Date("d-m-Y"));
		$datetime2->set_format("DD-MM-YYYY");
		$data['datetime2'] = $datetime2->render();		

		$this->load->helper('az_core');
		$js = az_add_js('dpt_report/vjs_dpt_report');
		$azapp->add_js($js);

		$view = $this->load->view('dpt_report/v_dpt_report', $data, true);
		$azapp->add_content($view);
		
		echo $azapp->render();	
	}

	function get_dpt() {
		$this->load->helper('az_core');
		$date_1 = $this->input->post('date_1');
		$date_2 = $this->input->post('date_2');

		$date_1 = Date('Y-m-d', strtotime($date_1));
		$date_2 = Date('Y-m-d', strtotime($date_2));

		$idcashier = $this->input->post("idcashier");
		
		$idoutlet = $this->input->post('idoutlet');
		$sess_idoutlet = $this->session->userdata('idoutlet');
		if (strlen($sess_idoutlet) > 0) {
			$idoutlet = $sess_idoutlet;
		}

		if (strlen($idoutlet) > 0) {
			$this->db->where('transaction_group.idoutlet', $idoutlet);
		}
		if (strlen($idcashier) > 0) {
			$this->db->where('transaction_group.iduser', $idcashier);
		}
		$this->db->where('transaction_group.status', 1);
		$this->db->where('date(date) >=', $date_1);
		$this->db->where('date(date) <=', $date_2);
		$this->db->join('customer', 'transaction_group.idcustomer = customer.idcustomer');
		$this->db->join('user', 'transaction_group.iduser = user.iduser');
		$this->db->select('*, transaction_group.idoutlet');
		$trx = $this->db->get('transaction_group');


		$this->db->where('status', 1);
		if (strlen($idoutlet) > 0) {
			$this->db->where('idoutlet', $idoutlet);
		}
		$data_outlet = $this->db->get('outlet');

		$arr_analysis = array();
		foreach ($data_outlet->result() as $key => $value) {
			$arr_analysis[$value->idoutlet]['name'] = $value->outlet_name;
			$arr_analysis[$value->idoutlet]['total_dpt'] = 0;
		}

		$arr = array();
		$grand_total = 0;
		foreach ($trx->result() as $key => $value) {
			$total_pay = $value->grand_total_final;
			$payment_status = $value->payment_status;
			if ($value->payment_status == 'PANJAR') {
				$total_pay = $value->total_panjar;
			}
			else if ($value->payment_status == 'BELUM BAYAR') {
				$total_pay = 0;
				$payment_status = 'NOPAY';
			}
			$arr[] = array(
				'nobill' => $value->code,
				'date' => $value->date,
				'customer' => $value->customer_name,
				'grand_discount' => $value->grand_discount,
				'before_discount' => $value->grand_total + $value->grand_add_cost + $value->grand_tax,
				'grand_total_final' => $value->grand_total_final,
				'total_pay' => $total_pay,
				'cashier' => $value->name,
				'status' => 'BARU',
				'payment_status' => $payment_status
			);

			$grand_total += $total_pay;
			$arr_analysis[$value->idoutlet]['total_dpt'] += $total_pay;
		}		
		

		//pickup
		if (strlen($idoutlet) > 0) {
			$this->db->where('transaction_group.idoutlet', $idoutlet);
		}
		if (strlen($idcashier) > 0) {
			$this->db->where('transaction_group.iduser', $idcashier);
		}
		$this->db->where('date(pickup_date) >=', $date_1);
		$this->db->where('date(pickup_date) <=', $date_2);
		$this->db->where('transaction_group_status', 'Selesai');
		$this->db->join('customer', 'transaction_group.idcustomer = customer.idcustomer');
		$this->db->where('transaction_group.status', 1);
		$this->db->join('user', 'transaction_group.iduser = user.iduser');
		$this->db->select('*, transaction_group.idoutlet');
		$trx = $this->db->get('transaction_group');
		

		$arr_pickup = array();
		$grand_total_pickup = 0;
		
		foreach ($trx->result() as $key => $value) {
			$total_pay = $value->grand_total_final;
			$payment_status = $value->payment_status;
			if ($value->payment_status == 'PANJAR') {
				$total_pay = $value->grand_total_final - $value->total_panjar;
				$payment_status = 'LUNAS PANJAR Rp '.az_thousand_separator($value->total_panjar);
			}
			else if ($value->payment_status == 'BELUM BAYAR') {
				$total_pay = $value->grand_total_final;
				$payment_status = 'PELUNASAN';
			}
			else if ($value->payment_status == 'CASH') {
				$total_pay = 0;
				$payment_status = 'PAID';
			}
			$arr_pickup[] = array(
				'nobill' => $value->code,
				'date' => $value->pickup_date,
				'customer' => $value->customer_name,
				'grand_total_final' => $value->grand_total_final,
				'total_pay' => $total_pay,
				'cashier' => $value->name,
				'status' => 'SELESAI',
				'payment_status' => $payment_status
			);

			$grand_total_pickup += $total_pay;

			$last_dpt = $arr_analysis[$value->idoutlet]['total_dpt'];
			$new_dpt = $last_dpt + $total_pay;

			$arr_analysis[$value->idoutlet]['total_dpt'] = $new_dpt;
		}
		

		if (strlen($idoutlet) > 0) {
			$this->db->where('outlay.idoutlet', $idoutlet);
		}
		if (strlen($idcashier) > 0) {
			$this->db->where('outlay.iduser', $idcashier);
		}
		$this->db->join('outlet', 'outlay.idoutlet = outlet.idoutlet');
		$this->db->where('outlay.status', 1);
		$this->db->where('date(datetime) >=', $date_1);
		$this->db->where('date(datetime) <=', $date_2);
		$this->db->join('outlay_type', 'outlay.idoutlay_type = outlay_type.idoutlay_type');
		$this->db->join('user', 'outlay.iduser = user.iduser');
		$outlay = $this->db->get('outlay');

		$param_outlay['data'] = $outlay;
		$v_outlay = $this->load->view('dpt_report/v_outlay', $param_outlay, true);

		if (strlen($idoutlet) > 0) {
			$this->db->where('transaction_group.idoutlet', $idoutlet);
		}
		if (strlen($idcashier) > 0) {
			$this->db->where('transaction_group.iduser', $idcashier);
		}
		$this->db->where('date(date) >=', $date_1);
		$this->db->where('date(date) <=', $date_2);
		$this->db->where('transaction_group.status', 1);
		$this->db->join('payment_type', 'transaction_group.idpayment_type = payment_type.idpayment_type', 'left');
		$this->db->join('customer', 'transaction_group.idcustomer = customer.idcustomer');
		$this->db->select("
			coalesce(sum(case when payment_status = 'CASH' then 1 else 0 end), 0) total_cash,
			coalesce(sum(case when payment_status = 'PANJAR' then 1 else 0 end), 0) total_panjar,
			coalesce(sum(case when payment_status = 'BELUM BAYAR' then 1 else 0 end), 0) total_not_paid,
			coalesce(sum(case when payment_status = 'CASH' then grand_total_final else 0 end), 0) amount_cash,
			coalesce(sum(case when payment_status = 'PANJAR' then total_panjar else 0 end), 0) amount_panjar,
			coalesce(sum(case when payment_status = 'BELUM BAYAR' then grand_total_final else 0 end), 0) amount_not_paid,
			count(grand_total_final) as total_dpt,
			coalesce(sum(grand_total_final), 0) as amount_dpt,
			count(grand_total_final) as total_transaction,
			coalesce(sum(grand_total_final), 0) as amount_transaction,
			coalesce(sum(case when payment_status = 'PANJAR' or payment_status = 'BELUM BAYAR' then 1 else 0 end), 0) total_piutang,
			coalesce(sum(case when payment_status = 'PANJAR' or payment_status = 'BELUM BAYAR' then (grand_total_final - total_panjar) else 0 end), 0) amount_piutang,
			coalesce(sum(case when grand_discount > 0 then 1 else 0 end), 0) total_discount,
			coalesce(sum(case when grand_discount > 0 then grand_discount else 0 end), 0) amount_discount

		");
		$data_payment = $this->db->get('transaction_group')->row();

		$param_payment['data'] = $data_payment;
		$param_payment['total'] = $grand_total;

		$v_payment = $this->load->view('dpt_report/v_payment', $param_payment, true);

		//dpt analysis
		if (strlen($idoutlet) > 0) {
			$this->db->where('transaction_group.idoutlet', $idoutlet);
		}
		if (strlen($idcashier) > 0) {
			$this->db->where('transaction_group.iduser', $idcashier);
		}
		$this->db->where('transaction_group.status', 1);
		$this->db->where('date(date) >=', $date_1);
		$this->db->where('date(date) <=', $date_2);
		$this->db->select('coalesce(sum(grand_total_final), 0) as total_amount, count(*) as total, coalesce(sum(total_pcs), 0) as total_pcs, transaction_group.idoutlet');
		$this->db->group_by('transaction_group.idoutlet');
		$trx_in = $this->db->get('transaction_group');


		if (strlen($idoutlet) > 0) {
			$this->db->where('transaction_group.idoutlet', $idoutlet);
		}
		if (strlen($idcashier) > 0) {
			$this->db->where('transaction_group.iduser', $idcashier);
		}
		$this->db->where('date(pickup_date) >=', $date_1);
		$this->db->where('date(pickup_date) <=', $date_2);
		$this->db->where('transaction_group_status', 'Selesai');
		$this->db->where('transaction_group.status', 1);
		$this->db->select('count(*) as total, coalesce(sum(total_pcs), 0) as total_pcs, transaction_group.idoutlet');
		$this->db->group_by('transaction_group.idoutlet');
		$trx_out = $this->db->get('transaction_group');
		
		foreach ($trx_in->result() as $trx_in_key => $trx_in_value) {
			$arr_analysis[$trx_in_value->idoutlet]['total_amount'] = az_thousand_separator($trx_in_value->total_amount);
			$arr_analysis[$trx_in_value->idoutlet]['total'] = $trx_in_value->total;
			$arr_analysis[$trx_in_value->idoutlet]['total_pcs'] = $trx_in_value->total_pcs;
		}

		foreach ($trx_out->result() as $trx_in_key => $trx_in_value) {
			$arr_analysis[$trx_in_value->idoutlet]['total_out'] = $trx_in_value->total;
			$arr_analysis[$trx_in_value->idoutlet]['total_pcs_out'] = $trx_in_value->total_pcs;
		}

		$param_analysis['data'] = $arr_analysis;

		$v_analysis = $this->load->view('dpt_report/v_analysis', $param_analysis, true);

		$result = array(
			'data' => $arr,
			'data_pickup' => $arr_pickup,
			'total' => $grand_total,
			'total_pickup' => $grand_total_pickup,
			'total_all' => $grand_total + $grand_total_pickup,
			'outlay' => $v_outlay,
			'payment' => $v_payment,
			'analysis' => $v_analysis
		);

		echo json_encode($result);
	
	}
}