<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customer extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('customer');
        $this->table = 'customer';
        $this->controller = 'customer';
        $this->load->helper('az_crud');
    }

	public function index(){
		$this->load->helper('az_location');
		$this->load->library('AZApp');
		$azapp = $this->azapp;
		$crud = $azapp->add_crud();

		$crud->set_column(array('#', azlang('Outlet'), azlang('Customer Code'), azlang('Customer Name'), 'Kategori Pelanggan', azlang('Address'), azlang('Email'), azlang('Phone'), 'Tanggal Lahir', 'Tgl Input', azlang('Action')));
		$crud->set_id($this->controller);
		$crud->set_default_url(true);

		$date = $azapp->add_datetime();
		$date->set_id('birthday');
		$date->set_name('birthday');
		$date->set_format('DD-MM-YYYY');
		$data['birthday'] = $date->render();

		$this->db->where('status', 1);
		$data['customer_category'] = $this->db->get('customer_category');

		$v_modal = $this->load->view('customer/v_customer', $data, true);
		$crud->set_form('form');
		$crud->set_modal($v_modal);
		$crud->set_modal_title('Data Pelanggan');
		$v_modal = $crud->generate_modal();

		if (strlen($this->session->userdata('idoutlet')) == 0) {
			$v_filter = $this->load->view('customer/v_top_customer', '', true);
			$crud->set_top_filter($v_filter);
		}
		
		$crud = $crud->render();
		$crud .= $v_modal;	
		$azapp->add_content($crud);


		$data_header['title'] = 'Data Pelanggan';
		$data_header['breadcrumb'] = array('customers', 'customer');
		$azapp->set_data_header($data_header);
		
		echo $azapp->render();	
	}

	public function get() {
		$this->load->library('AZApp');
		$crud = $this->azapp->add_crud();
		$crud->set_select('idcustomer, outlet_name, customer_code, customer_name, customer_category_name, customer.address, customer.email, customer.phone, date_format(birthday, "%d-%m-%Y") as birthday, date_format(customer.created, "%d-%m-%Y %H:%i:%s") as created');
		$crud->set_select_table('idcustomer, outlet_name, customer_code, customer_name, customer_category_name, customer.address, customer.email, customer.phone, birthday, created');
		$crud->add_join('outlet', 'left');
		$crud->add_join('customer_category', 'left');
		$crud->set_filter('customer_name');
		$crud->set_sorting('outlet_name, customer_code, customer_name, customer_category_name, customer.address, customer.email, customer.phone, birthday, customer.created');
		$crud->set_id($this->controller);
		$crud->add_where("customer.status > 0");
		$crud->set_table($this->table);
		$sess_idoutlet = $this->session->userdata('idoutlet');
		if (strlen($sess_idoutlet) > 0) {
			$crud->add_where('customer.idoutlet = '.$sess_idoutlet);
		}
		$crud->set_order_by('customer_name');
		echo $crud->get_table();
	}

	public function save(){
		$data = array();
		$data_post = $this->input->post();
		$idpost = azarr($data_post, 'id'.$this->table);
		$data['sMessage'] = '';
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('', '');

		$idoutlet = $this->session->userdata('idoutlet');
		if (strlen($idoutlet) == 0) {
			$this->form_validation->set_rules('idoutlet', azlang('Outlet'), 'required|trim');
			$idoutlet = azarr($data_post, 'idoutlet');
		}
		$this->form_validation->set_rules('customer_name', azlang('Customer Name'), 'required|trim|max_length[200]');
		$this->form_validation->set_rules('idcustomer_category', 'Kategori Pelanggan', 'required|trim|max_length[200]');

		$err_code = 0;
		$err_message = '';

		if($this->form_validation->run() == TRUE){
			$data_save = array(
				'idoutlet' => $idoutlet,
				'idcustomer_category' => $this->input->post('idcustomer_category'),
				'customer_name' => $this->input->post('customer_name'),
				'address' => $this->input->post('address'),
				'email' => $this->input->post('email'),
				'phone' => $this->input->post('phone'),
				'birthday' => az_crud_date($this->input->post('birthday'), 'Y-m-d'),
			);

			if (strlen($idpost) == 0) {
				$data_code = az_generate_customer_code($idoutlet);

				$code = azarr($data_code, 'customer_code');
				$code_number = azarr($data_code, 'customer_code_num');
				$data_save['customer_code'] = $code;
				$data_save['customer_code_num'] = $code_number;
			}

			$response_save = az_crud_save($idpost, $this->table, $data_save);
			$err_code = azarr($response_save, 'err_code');
			$err_message = azarr($response_save, 'err_message');
			$insert_id = azarr($response_save, 'insert_id');
		}
		else {
			$err_code++;
			$err_message = validation_errors();
		}

		$data["sMessage"] = $err_message;
		echo json_encode($data);
	}

	public function edit() {
		$this->db->join('outlet', 'customer.idoutlet = outlet.idoutlet', 'left');
		az_crud_edit('idcustomer, customer_code, customer_name, customer.address, customer.phone, customer.email, customer.idoutlet, outlet_name as ajax_idoutlet, date_format(birthday, "%d-%m-%Y") as birthday');
	}

	public function delete() {
		$id = $this->input->post('id');
		az_crud_delete($this->table, $id);
	}
}