<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Additional_cost extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('additional_cost');

        $this->table = 'additional_cost';
        $this->load->helper('az_crud');
        $this->load->library('AZApp');
        $this->crud = $this->azapp->add_crud();
    }

	public function index(){
		$azapp = $this->azapp;
		$crud = $this->crud;

		$crud->set_column(array(azlang('No'), 'Nama Biaya', 'Harga (Rp)', azlang('Action')));
		$crud->set_id($this->table);
		$crud->set_default_url(true);

		$v_modal = $this->load->view('additional_cost/v_additional_cost', '', true);
		$crud->set_form('form');
		$crud->set_modal($v_modal);
		$crud->set_modal_title('Biaya Tambahan');
		$v_modal = $crud->generate_modal();
		
		$crud = $crud->render();
		$crud .= $v_modal;	
		$azapp->add_content($crud);

		$data_header['title'] = 'Biaya Tambahan';
		$data_header['breadcrumb'] = array('master', 'additional_cost');
		$azapp->set_data_header($data_header);
		
		echo $azapp->render();	
	}

	public function get() {
		$crud = $this->crud;
		$crud->set_select('idadditional_cost, cost_name, price');
		$crud->set_filter('cost_name, price');
		$crud->set_sorting('cost_name, price');
		$crud->set_select_number('1');
		$crud->set_select_align(',right');
		$crud->set_id($this->table);
		$crud->add_where("status > 0");
		$crud->set_table($this->table);

		echo $crud->get_table();
	}

	public function save(){
		$data = array();
		$data_post = $this->input->post();
		$idpost = azarr($data_post, 'id'.$this->table);
		$data["sMessage"] = "";
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('', '');

		$this->form_validation->set_rules('cost_name', 'Nama Biaya', 'required|trim|max_length[200]');
		$this->form_validation->set_rules('price', 'Harga', 'required|trim|max_length[200]');

		$err_code = 0;
		$err_message = "";

		if($this->form_validation->run() == TRUE){
			$data_save = array(
				"cost_name" => azarr($data_post, 'cost_name'),
				'price' => az_crud_number($this->input->post('price'))
			);

			$response_save = az_crud_save($idpost, $this->table, $data_save);
			$err_code = azarr($response_save, 'err_code');
			$err_message = azarr($response_save, 'err_message');
		}

		$data["sMessage"] = validation_errors().$err_message;
		echo json_encode($data);
	}

	public function edit() {
		az_crud_edit('idadditional_cost, cost_name, price');
	}

	public function delete() {
		$id = $this->input->post("id");
		az_crud_delete('additional_cost', $id);
	}
}