SET foreign_key_checks = 0;
#
# TABLE STRUCTURE FOR: additional_cost
#

DROP TABLE IF EXISTS `additional_cost`;

CREATE TABLE `additional_cost` (
  `idadditional_cost` int(11) NOT NULL AUTO_INCREMENT,
  `cost_name` varchar(50) DEFAULT NULL,
  `price` double DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idadditional_cost`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `additional_cost` (`idadditional_cost`, `cost_name`, `price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', 'Pewarna', '10000', '2021-03-13 05:55:30', 'superadmin', '2021-03-13 05:55:30', 'superadmin', '1');
INSERT INTO `additional_cost` (`idadditional_cost`, `cost_name`, `price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', 'Sisip', '10000', '2021-03-13 05:55:42', 'superadmin', '2021-03-13 05:55:42', 'superadmin', '1');


#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a4fed31aef090b27f7bac3abd0165a36d5333c91', '180.241.45.142', '1717337014', '__ci_last_regenerate|i:1717336993;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('07976ec18d850770fadb99e381d0f0b10b981bf2', '180.241.45.142', '1717337413', '__ci_last_regenerate|i:1717337111;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7f83bfb01dc32af96196edc86e54083cb035c15c', '2404:c0:1c10::377c:61f8', '1717337522', '__ci_last_regenerate|i:1717337446;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('96af5e88791ef92cc352bbc5352e6ebd73b2313b', '2404:c0:1c10::377c:61f8', '1717339631', '__ci_last_regenerate|i:1717339566;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('de4067be7c1ad59886f3c40c6c00ef69f4a8290a', '114.122.8.154', '1717341530', '__ci_last_regenerate|i:1717341473;username|s:5:\"Risky\";iduser|s:1:\"9\";name|s:5:\"Risky\";idrole|s:1:\"3\";role_name|s:6:\"driver\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0f7eddf7d68e948f720634a2aa1b4c7275bef13a', '114.122.8.154', '1717342791', '__ci_last_regenerate|i:1717342493;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c93d508deab513ca41f2dd4b2cc3ae80a6e849ae', '114.122.8.154', '1717343729', '__ci_last_regenerate|i:1717343434;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ee14b387d06a78926b821a4f661b6fecc31198c', '114.122.8.154', '1717344136', '__ci_last_regenerate|i:1717344104;username|s:13:\"production001\";iduser|s:1:\"4\";name|s:11:\"Om Produksi\";idrole|s:1:\"4\";role_name|s:10:\"production\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f8c28001e0428f36e5173cec6cf64601fbf960c2', '114.122.8.154', '1717346083', '__ci_last_regenerate|i:1717345880;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ac2d25684f57af3ad581a2a5d733be82aada9f7', '114.122.8.154', '1717346576', '__ci_last_regenerate|i:1717346504;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f24deda842f1b765e77e9b809b18353225605e04', '180.241.45.142', '1717349306', '__ci_last_regenerate|i:1717349125;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('85906fc1c18963b2f15b5ca3db98e3087346dd03', '180.241.45.142', '1717349540', '__ci_last_regenerate|i:1717349477;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('20f2b604edca4953a01c50aedd31e931f044e588', '180.241.45.142', '1717349875', '__ci_last_regenerate|i:1717349815;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c1b4e6c68174ea4dc2f78b01f277ea13242828e6', '180.241.45.142', '1717350351', '__ci_last_regenerate|i:1717350069;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('b85077d9a78ed01dd178f2a01e7a45fdfd47f274', '180.241.45.142', '1717350942', '__ci_last_regenerate|i:1717350622;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('c46bd3f53d47ad8871f338d84eae082b7e178aec', '180.241.45.142', '1717351182', '__ci_last_regenerate|i:1717350949;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1acbde4082f034055035452fb4f469e0a107f1af', '180.241.45.142', '1717351530', '__ci_last_regenerate|i:1717351253;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('799eb7f61c450359342a98ad26d4d07ed47bc1c8', '180.241.45.142', '1717351669', '__ci_last_regenerate|i:1717351401;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3d476d7840ce6fbc44f171171bdeaae09f16d8a9', '180.241.45.142', '1717351939', '__ci_last_regenerate|i:1717351705;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('cb4117e11a0e1c43325946d711fe82d260c1c1b0', '180.241.45.142', '1717351987', '__ci_last_regenerate|i:1717351983;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d190b701f3853291973c4b1288f41ef662e7953e', '180.241.45.142', '1717352652', '__ci_last_regenerate|i:1717352233;username|s:13:\"production001\";iduser|s:1:\"4\";name|s:11:\"Om Produksi\";idrole|s:1:\"4\";role_name|s:10:\"production\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4fb7f8f7783271135bd6bc4efa90ca2367e31f28', '180.241.45.142', '1717357117', '__ci_last_regenerate|i:1717352328;username|s:13:\"production001\";iduser|s:1:\"4\";name|s:11:\"Om Produksi\";idrole|s:1:\"4\";role_name|s:10:\"production\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('196feb78d6b338a9ee0ca08be50f84e350a4b63d', '180.241.45.142', '1717352703', '__ci_last_regenerate|i:1717352664;username|s:13:\"production001\";iduser|s:1:\"4\";name|s:11:\"Om Produksi\";idrole|s:1:\"4\";role_name|s:10:\"production\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ce018fff11d2dc016ff20a8d5f160c899b53c23c', '2404:c0:1c30::a67:27b7', '1717357138', '__ci_last_regenerate|i:1717357136;username|s:13:\"production001\";iduser|s:1:\"4\";name|s:11:\"Om Produksi\";idrole|s:1:\"4\";role_name|s:10:\"production\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d963b5c6f43780094097c2dd6538a289c7635c29', '2404:c0:1c10::37a4:f2c2', '1717417833', '__ci_last_regenerate|i:1717417833;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ea54a563c251dd4816e689eb317ad8a6b12382fa', '2404:c0:1c10::37a4:f2c2', '1717418357', '__ci_last_regenerate|i:1717418357;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6f80fc888ccd008f4667e7a4b9bce5140583c294', '202.67.46.230', '1717445242', '__ci_last_regenerate|i:1717445005;username|s:10:\"superadmin\";iduser|s:1:\"1\";name|s:10:\"Superadmin\";idrole|N;role_name|N;idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8352f641d633958010f717a2d579b86ce95264c4', '2404:c0:1c10::37c6:4316', '1717445780', '__ci_last_regenerate|i:1717445703;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('aced4022184f2763ca8fe029b1628b4647dfd931', '2404:c0:1c10::37c6:4316', '1717446189', '__ci_last_regenerate|i:1717445881;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('d420445ceedc064e0cc6aaeb3d57fe77f674dd30', '2404:c0:1c10::37d1:385f', '1717447374', '__ci_last_regenerate|i:1717447329;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9393348672d7988cee8cc616a694266172ad5005', '2404:c0:1c10::37c8:5101', '1717449058', '__ci_last_regenerate|i:1717448873;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('a6337fc12b867be95f1724a69e534f8f87a51df8', '2404:c0:1c10::37c8:5101', '1717449235', '__ci_last_regenerate|i:1717449176;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('67543256f852aa775c1467d75af7e7f020b4d40e', '2404:c0:1c10::37d5:ca87', '1717463240', '__ci_last_regenerate|i:1717463239;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e4bc64aee6e13207281cad2a8137887047941fe1', '2404:c0:1c10::37d5:ca87', '1717463834', '__ci_last_regenerate|i:1717463737;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5594c653ebabb5ce508f758b73403956d3962616', '2404:c0:1c10::37d5:ca87', '1717464339', '__ci_last_regenerate|i:1717464282;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ae1ef3878a927b68541c8c39615db50a0ed24076', '2404:c0:1c10::37d5:ca87', '1717465134', '__ci_last_regenerate|i:1717464986;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('7e663104114f296efa10e4590f1dd94d2fe2ddef', '36.85.27.118', '1717469891', '__ci_last_regenerate|i:1717469891;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f81cc94bb44825eaafeb7f12bfd0e87ed8740b25', '2404:c0:1c10::37d5:ca87', '1717475877', '__ci_last_regenerate|i:1717475710;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1c992ba393e621439792377ae3f522005a18d1be', '2404:c0:1c10::37d5:ca87', '1717476536', '__ci_last_regenerate|i:1717476536;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('f863fc7ece39cc747e4d383b951efc5f8a38ace8', '2404:c0:1c10::37d5:ca87', '1717477492', '__ci_last_regenerate|i:1717477492;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('353f068545b1034b5dcf1a54a52adae7fb77fe28', '2404:c0:1c10::37d4:dd00', '1717480921', '__ci_last_regenerate|i:1717480921;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('de52828e2ed83289ffd24bdc644d074bd56bb4f9', '2404:c0:1c10::37d4:dd00', '1717483742', '__ci_last_regenerate|i:1717483513;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3f4f4f142ae7532014df0ec3b454bdab7b336601', '2404:c0:1c10::37d4:dd00', '1717485577', '__ci_last_regenerate|i:1717485575;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ce97cb875477b5772ff0eb3c60a48bdb5fa2c0ac', '2404:c0:1c10::37d4:dd00', '1717498640', '__ci_last_regenerate|i:1717498451;username|s:10:\"cashier001\";iduser|s:1:\"5\";name|s:10:\"Mbak Kasir\";idrole|s:1:\"2\";role_name|s:7:\"cashier\";idoutlet|s:2:\"14\";azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('3e6560a1915d3f4d3458544d50ab515f91c75859', '202.67.41.226', '1717538520', '__ci_last_regenerate|i:1717538446;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('329ee3ea87ab0e67df2b26bff475526bc2d44a71', '202.67.41.226', '1717538864', '__ci_last_regenerate|i:1717538854;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('e4ca811d3d9f7a8733198547ec5f332589d3b39a', '202.67.41.226', '1717539424', '__ci_last_regenerate|i:1717539178;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('953afba847a1387f0e903bf1c9ba3c631b31cd50', '202.67.41.226', '1717539482', '__ci_last_regenerate|i:1717539482;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4a6fd11f8ecf9dd493732517fc5176219be7ac3b', '202.67.41.226', '1717539482', '__ci_last_regenerate|i:1717539482;username|s:13:\"administrator\";iduser|s:1:\"2\";name|s:13:\"administrator\";idrole|s:1:\"1\";role_name|s:13:\"administrator\";idoutlet|N;azlang|s:10:\"indonesian\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('de29b3fa4c56722b66982781098c78512e3cb1df', '202.67.46.37', '1717541715', '__ci_last_regenerate|i:1717541698;username|s:10:\"superadmin\";iduser|s:1:\"1\";name|s:10:\"Superadmin\";idrole|N;role_name|N;idoutlet|N;azlang|s:10:\"indonesian\";');


#
# TABLE STRUCTURE FOR: colour
#

DROP TABLE IF EXISTS `colour`;

CREATE TABLE `colour` (
  `idcolour` int(11) NOT NULL AUTO_INCREMENT,
  `colour_name` varchar(50) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idcolour`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1;

INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', 'Merah Muda', '2021-01-16 16:30:09', 'superadmin', '2021-01-16 16:30:15', 'superadmin', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', 'Putih', '2021-01-16 16:30:19', 'superadmin', '2021-01-16 16:30:19', 'superadmin', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', 'Hitam', '2021-04-21 00:18:58', 'administrator', '2021-04-21 00:18:58', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('4', 'Merah', '2021-04-21 00:19:10', 'administrator', '2021-04-21 00:19:10', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('5', 'Kuning', '2021-04-21 00:19:24', 'administrator', '2021-04-21 00:19:24', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('6', 'Biru', '2021-04-21 00:19:39', 'administrator', '2021-04-21 00:19:39', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('7', 'Biru tua', '2021-04-21 00:19:49', 'administrator', '2021-04-21 00:19:49', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('8', 'Biru muda', '2021-04-21 00:20:02', 'administrator', '2021-04-21 00:20:02', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('9', 'Hijau', '2021-04-21 00:20:15', 'administrator', '2021-04-21 00:20:15', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('10', 'Orange', '2021-04-21 00:20:26', 'administrator', '2021-04-21 00:20:26', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('11', 'Lila', '2021-04-21 00:20:34', 'administrator', '2021-04-21 00:20:34', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('12', 'Ungu', '2021-04-21 00:20:43', 'administrator', '2021-04-21 00:20:43', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('13', 'Crream', '2021-04-21 00:21:15', 'administrator', '2021-04-21 00:21:24', 'administrator', '0');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('14', 'Krem ', '2021-04-21 00:21:32', 'administrator', '2021-04-21 00:21:32', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('15', 'Krem muda', '2021-04-21 00:21:42', 'administrator', '2021-04-21 00:21:42', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('16', 'Krem tua', '2021-04-21 00:21:53', 'administrator', '2021-04-21 00:21:53', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('17', 'Coklat', '2021-04-21 00:22:41', 'administrator', '2021-04-21 00:22:41', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('18', 'Coklat  tua', '2021-04-21 00:22:51', 'administrator', '2021-04-21 00:22:51', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('19', 'Coklat muda', '2021-04-21 00:23:00', 'administrator', '2021-04-21 00:23:00', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('20', 'Pink', '2021-04-21 00:23:20', 'administrator', '2021-04-21 00:23:20', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('21', 'Peach', '2021-04-21 00:23:36', 'administrator', '2021-04-21 00:23:36', 'administrator', '1');
INSERT INTO `colour` (`idcolour`, `colour_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('22', 'Abu-abu', '2021-04-21 00:23:59', 'administrator', '2021-04-21 00:23:59', 'administrator', '1');


#
# TABLE STRUCTURE FOR: config
#

DROP TABLE IF EXISTS `config`;

CREATE TABLE `config` (
  `idconfig` int(11) NOT NULL AUTO_INCREMENT,
  `key` text,
  `value` text,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idconfig`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO `config` (`idconfig`, `key`, `value`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', 'app_name', 'Laundry', '2016-11-04 02:02:19', NULL, '2016-11-04 02:02:19', NULL, '1');
INSERT INTO `config` (`idconfig`, `key`, `value`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', 'app_description', 'Laundry Management System', '2016-11-04 02:02:31', NULL, '2016-11-04 02:02:31', NULL, '1');
INSERT INTO `config` (`idconfig`, `key`, `value`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', 'app_preface', '<p>Selamat bekerja</p>\r\n', '2016-11-13 20:24:26', NULL, '2016-11-13 20:24:27', NULL, '1');
INSERT INTO `config` (`idconfig`, `key`, `value`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('4', 'app_login_title', 'AZLaundry', '2016-11-20 18:42:44', NULL, '2016-11-20 18:42:45', NULL, '1');
INSERT INTO `config` (`idconfig`, `key`, `value`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('5', 'app_footer_nota', '~~~ KETENTUAN~~~<br />\r\n1. Kepada Pelanggan<br />\r\n2. Loundry yang diterima<br />\r\n3. laundry yang ambil', NULL, NULL, NULL, NULL, '1');
INSERT INTO `config` (`idconfig`, `key`, `value`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('6', 'duedate', '2', '2021-01-16 17:04:54', NULL, '2021-01-16 17:04:54', NULL, '1');


#
# TABLE STRUCTURE FOR: customer
#

DROP TABLE IF EXISTS `customer`;

CREATE TABLE `customer` (
  `idcustomer` int(11) NOT NULL AUTO_INCREMENT,
  `idoutlet` int(11) DEFAULT NULL,
  `idcustomer_category` int(11) DEFAULT NULL,
  `customer_code_num` double DEFAULT NULL,
  `customer_code` varchar(200) DEFAULT NULL,
  `customer_name` varchar(200) DEFAULT NULL,
  `address` varchar(300) DEFAULT NULL,
  `email` varchar(200) DEFAULT NULL,
  `phone` varchar(200) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idcustomer`),
  KEY `FK_customer_outlet` (`idoutlet`),
  KEY `FK_customer_customer_category` (`idcustomer_category`),
  CONSTRAINT `FK_customer_customer_category` FOREIGN KEY (`idcustomer_category`) REFERENCES `customer_category` (`idcustomer_category`),
  CONSTRAINT `FK_customer_outlet` FOREIGN KEY (`idoutlet`) REFERENCES `outlet` (`idoutlet`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=latin1;

INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('31', '14', '11', '1', 'OT1-00001', 'Spiderman', NULL, '', '', '1978-07-21', '2021-01-16 12:20:18', 'superadmin', '2021-01-16 12:25:03', 'superadmin', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('32', '14', '1', '2', 'OT1-00002', 'Batman', NULL, 'batmtan@gmail.com', '08123123', '1990-12-14', '2021-01-16 12:20:59', 'superadmin', '2021-03-13 05:33:14', 'superadmin', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('33', '14', NULL, NULL, '00002', 'Bagus', 'Test', '', '08888888iio', NULL, '2021-04-19 07:19:13', 'cashier001', '2021-04-19 07:19:13', 'cashier001', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('34', '14', '1', '3', 'OT1-00003', 'Superman', 'Magelang', 'superman@gmail.com', '081232', '2021-04-19', '2021-04-19 11:05:17', 'cashier001', '2021-04-19 11:16:18', 'administrator', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('35', '14', '1', '4', 'OT1-00004', 'Clara', 'Jl sehati', '', '08888888626', '1987-07-23', '2021-04-19 11:24:25', 'cashier001', '2024-05-04 19:32:20', 'administrator', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('36', '14', '11', '5', 'OT1-00005', 'Heri', 'Jl coba', '', '08626626266', '2001-08-18', '2021-04-19 12:19:09', 'cashier001', '2021-04-19 12:19:09', 'cashier001', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('37', '14', '11', '6', 'OT1-00006', 'Lala', 'Jl kado', '', '0866252515', '1998-07-08', '2021-04-21 00:17:40', 'cashier001', '2021-04-21 00:17:40', 'cashier001', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('38', '15', '11', '1', 'OT2-00001', 'Koko', 'Jl kikk', '', '087282727', '2021-04-06', '2021-04-21 00:53:15', 'administrator', '2021-04-21 00:53:15', 'administrator', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('39', '15', '11', '2', 'OT2-00002', 'Moml', 'Jl kenari', '', '086526266626', '2007-07-21', '2021-04-21 01:09:29', 'administrator', '2021-04-21 01:09:29', 'administrator', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('40', '15', '11', '3', 'OT2-00003', 'Heru', 'Jl Baca', '', '0842662617', '2006-08-24', '2021-04-21 01:13:26', 'administrator', '2021-04-21 01:13:26', 'administrator', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('41', '14', '1', '7', 'OT1-00007', 'Rudi', 'Jl selamat', '', '0868272727w72', NULL, '2021-06-18 04:12:22', 'administrator', '2021-06-18 04:12:22', 'administrator', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('42', '15', '11', '4', 'OT2-00004', 'Rudi', '', '', '08625268727', NULL, '2021-06-18 04:17:42', 'Kasir', '2021-06-18 04:17:42', 'Kasir', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('43', '14', '11', '8', 'OT1-00008', 'Atok', 'Jl kita', 'Atok@gmail.com', '081726261717', '1980-11-27', '2021-08-18 23:47:54', 'Rudi', '2021-08-18 23:47:54', 'Rudi', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('44', '14', '11', '9', 'OT1-00009', 'Goto', 'Kl kita', 'G@gmaol.com', '086262626', NULL, '2021-08-18 23:58:06', 'Rudi', '2021-08-18 23:58:06', 'Rudi', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('45', '14', '11', '10', 'OT1-00010', 'Toto', 'Jl hula', 'T@gmail.com', '', NULL, '2021-08-19 00:01:57', 'Rudi', '2021-08-19 00:01:57', 'Rudi', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('46', '16', '11', '1', '005-00001', 'Bona', 'Jl', '', '088888888', NULL, '2024-05-06 07:46:40', 'cindy5567', '2024-05-06 07:46:40', 'cindy5567', '1');
INSERT INTO `customer` (`idcustomer`, `idoutlet`, `idcustomer_category`, `customer_code_num`, `customer_code`, `customer_name`, `address`, `email`, `phone`, `birthday`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('47', '14', '11', '11', 'OT1-00011', 'siapa', 'satu', '', '0812345678', NULL, '2024-05-06 22:42:22', 'cashier001', '2024-05-06 22:42:22', 'cashier001', '1');


#
# TABLE STRUCTURE FOR: customer_category
#

DROP TABLE IF EXISTS `customer_category`;

CREATE TABLE `customer_category` (
  `idcustomer_category` int(11) NOT NULL AUTO_INCREMENT,
  `customer_category_name` varchar(50) DEFAULT NULL,
  `discount_amount` double DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idcustomer_category`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO `customer_category` (`idcustomer_category`, `customer_category_name`, `discount_amount`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', 'Gold', '10', '2021-01-16 12:48:50', 'superadmin', '2021-01-16 12:48:50', 'superadmin', '1');
INSERT INTO `customer_category` (`idcustomer_category`, `customer_category_name`, `discount_amount`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', 'Silver', '5', '2021-01-16 12:48:55', 'superadmin', '2021-01-16 12:48:55', 'superadmin', '1');
INSERT INTO `customer_category` (`idcustomer_category`, `customer_category_name`, `discount_amount`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', 'Coorporate', '2', '2021-01-16 12:49:03', 'superadmin', '2021-01-16 12:51:16', 'superadmin', '1');
INSERT INTO `customer_category` (`idcustomer_category`, `customer_category_name`, `discount_amount`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('11', 'Reguler', '0', '2021-01-16 13:21:43', 'superadmin', '2021-01-16 13:21:43', 'superadmin', '1');


#
# TABLE STRUCTURE FOR: dstb_clean
#

DROP TABLE IF EXISTS `dstb_clean`;

CREATE TABLE `dstb_clean` (
  `iddstb_clean` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `idoutlet` int(11) DEFAULT NULL,
  `idcashier` int(11) DEFAULT NULL,
  `iddriver` int(11) DEFAULT NULL,
  `dstb_date` date DEFAULT NULL,
  `tgl_diantar` datetime DEFAULT NULL,
  `tgl_end_process` datetime DEFAULT NULL,
  `dstb_number` int(11) DEFAULT NULL,
  `dstb_code` varchar(50) DEFAULT NULL,
  `total_bill` int(11) DEFAULT NULL,
  `total_pcs` int(11) DEFAULT NULL,
  `dstb_clean_status` varchar(50) DEFAULT 'BARU' COMMENT 'BARU, DIANTAR, END PROCESS',
  `dstb_note` varchar(200) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`iddstb_clean`) USING BTREE,
  KEY `FK_dstb_clean_outlet` (`idoutlet`) USING BTREE,
  KEY `FK_dstb_clean_user` (`idcashier`) USING BTREE,
  KEY `FK_dstb_clean_user_2` (`iddriver`) USING BTREE,
  CONSTRAINT `FK_dstb_clean_outlet` FOREIGN KEY (`idoutlet`) REFERENCES `outlet` (`idoutlet`),
  CONSTRAINT `FK_dstb_clean_user` FOREIGN KEY (`idcashier`) REFERENCES `user` (`iduser`),
  CONSTRAINT `FK_dstb_clean_user_2` FOREIGN KEY (`iddriver`) REFERENCES `user` (`iduser`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO `dstb_clean` (`iddstb_clean`, `idoutlet`, `idcashier`, `iddriver`, `dstb_date`, `tgl_diantar`, `tgl_end_process`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_clean_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', '14', '2', '3', '2022-07-29', '2024-05-31 09:18:18', NULL, '1', 'OT1-29072022-001', '1', '2', 'DIANTAR', '', '2024-05-30 10:51:31', 'administrator', '2024-05-30 10:51:31', 'administrator', '1');
INSERT INTO `dstb_clean` (`iddstb_clean`, `idoutlet`, `idcashier`, `iddriver`, `dstb_date`, `tgl_diantar`, `tgl_end_process`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_clean_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', '14', '4', '9', '2024-05-31', '2024-05-31 06:42:12', '2024-05-31 09:15:25', '1', 'OT1-31052024-001', '1', '0', 'END PROCESS', 'oo', '2024-05-31 06:41:02', 'production001', '2024-05-31 06:41:02', 'production001', '1');
INSERT INTO `dstb_clean` (`iddstb_clean`, `idoutlet`, `idcashier`, `iddriver`, `dstb_date`, `tgl_diantar`, `tgl_end_process`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_clean_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', '14', '4', '3', '2024-05-31', '2024-05-31 09:17:56', NULL, '2', 'OT1-31052024-002', '1', '0', 'DIANTAR', '', '2024-05-31 09:10:22', 'production001', '2024-05-31 09:10:22', 'production001', '1');
INSERT INTO `dstb_clean` (`iddstb_clean`, `idoutlet`, `idcashier`, `iddriver`, `dstb_date`, `tgl_diantar`, `tgl_end_process`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_clean_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('4', '14', '4', '3', '2024-05-31', NULL, NULL, '3', 'OT1-31052024-003', '4', '6', 'DIPROSES', 'Atas nama Clara super. Expres', '2024-05-31 09:45:25', 'production001', '2024-05-31 09:45:25', 'production001', '1');
INSERT INTO `dstb_clean` (`iddstb_clean`, `idoutlet`, `idcashier`, `iddriver`, `dstb_date`, `tgl_diantar`, `tgl_end_process`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_clean_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('5', '14', '4', '3', '2024-06-01', '2024-06-01 18:26:22', NULL, '1', 'OT1-01062024-001', '2', '3', 'DIANTAR', 'Tets', '2024-06-01 18:24:06', 'production001', '2024-06-01 18:24:06', 'production001', '1');
INSERT INTO `dstb_clean` (`iddstb_clean`, `idoutlet`, `idcashier`, `iddriver`, `dstb_date`, `tgl_diantar`, `tgl_end_process`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_clean_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('6', '14', '2', '3', '2024-06-04', NULL, NULL, '1', 'OT1-04062024-001', '1', '2', 'DIPROSES', '', '2024-06-04 03:24:04', 'administrator', '2024-06-04 03:24:04', 'administrator', '1');


#
# TABLE STRUCTURE FOR: dstb_clean_detail
#

DROP TABLE IF EXISTS `dstb_clean_detail`;

CREATE TABLE `dstb_clean_detail` (
  `iddstb_clean_detail` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `iddstb_clean` bigint(20) unsigned DEFAULT NULL,
  `idtransaction_group` bigint(20) unsigned DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`iddstb_clean_detail`) USING BTREE,
  KEY `FK_dstb_clean_detail_dstb_clean` (`iddstb_clean`) USING BTREE,
  KEY `FK_dstb_clean_detail_transaction_group` (`idtransaction_group`) USING BTREE,
  CONSTRAINT `FK_dstb_clean_detail_dstb_clean` FOREIGN KEY (`iddstb_clean`) REFERENCES `dstb_clean` (`iddstb_clean`),
  CONSTRAINT `FK_dstb_clean_detail_transaction_group` FOREIGN KEY (`idtransaction_group`) REFERENCES `transaction_group` (`idtransaction_group`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

INSERT INTO `dstb_clean_detail` (`iddstb_clean_detail`, `iddstb_clean`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', '1', '48', '2024-05-30 10:51:31', 'administrator', '2024-05-30 10:51:31', 'administrator', '1');
INSERT INTO `dstb_clean_detail` (`iddstb_clean_detail`, `iddstb_clean`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', '2', '31', '2024-05-31 06:41:02', 'production001', '2024-05-31 06:41:02', 'production001', '1');
INSERT INTO `dstb_clean_detail` (`iddstb_clean_detail`, `iddstb_clean`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', '3', '40', '2024-05-31 09:10:22', 'production001', '2024-05-31 09:10:22', 'production001', '1');
INSERT INTO `dstb_clean_detail` (`iddstb_clean_detail`, `iddstb_clean`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('4', '4', '42', '2024-05-31 09:45:25', 'production001', '2024-05-31 09:45:25', 'production001', '1');
INSERT INTO `dstb_clean_detail` (`iddstb_clean_detail`, `iddstb_clean`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('5', '4', '43', '2024-05-31 09:45:25', 'production001', '2024-05-31 09:45:25', 'production001', '1');
INSERT INTO `dstb_clean_detail` (`iddstb_clean_detail`, `iddstb_clean`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('6', '4', '47', '2024-05-31 09:45:25', 'production001', '2024-05-31 09:45:25', 'production001', '1');
INSERT INTO `dstb_clean_detail` (`iddstb_clean_detail`, `iddstb_clean`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('7', '4', '76', '2024-05-31 09:45:25', 'production001', '2024-05-31 09:45:25', 'production001', '1');
INSERT INTO `dstb_clean_detail` (`iddstb_clean_detail`, `iddstb_clean`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('8', '5', '50', '2024-06-01 18:24:06', 'production001', '2024-06-01 18:24:06', 'production001', '1');
INSERT INTO `dstb_clean_detail` (`iddstb_clean_detail`, `iddstb_clean`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('9', '5', '39', '2024-06-01 18:24:06', 'production001', '2024-06-01 18:24:06', 'production001', '1');
INSERT INTO `dstb_clean_detail` (`iddstb_clean_detail`, `iddstb_clean`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('10', '6', '58', '2024-06-04 03:24:04', 'administrator', '2024-06-04 03:24:04', 'administrator', '1');


#
# TABLE STRUCTURE FOR: dstb_process
#

DROP TABLE IF EXISTS `dstb_process`;

CREATE TABLE `dstb_process` (
  `iddstb_process` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `idoutlet` int(11) DEFAULT NULL,
  `idcashier` int(11) DEFAULT NULL,
  `iddriver` int(11) DEFAULT NULL,
  `idproduction` int(11) DEFAULT NULL,
  `dstb_date` datetime DEFAULT NULL,
  `tgl_dijemput` datetime DEFAULT NULL,
  `tgl_diproses` datetime DEFAULT NULL,
  `dstb_number` int(11) DEFAULT NULL,
  `dstb_code` varchar(50) DEFAULT NULL,
  `total_bill` int(11) DEFAULT NULL,
  `total_pcs` int(11) DEFAULT NULL,
  `dstb_process_status` varchar(50) DEFAULT 'BARU' COMMENT 'BARU, DIJEMPUT, PROSES',
  `dstb_note` varchar(200) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`iddstb_process`),
  KEY `FK_dstb_process_outlet` (`idoutlet`),
  KEY `FK_dstb_process_user` (`idcashier`),
  KEY `FK_dstb_process_user_2` (`iddriver`),
  KEY `FK_dstb_process_user_3` (`idproduction`),
  CONSTRAINT `FK_dstb_process_outlet` FOREIGN KEY (`idoutlet`) REFERENCES `outlet` (`idoutlet`),
  CONSTRAINT `FK_dstb_process_user` FOREIGN KEY (`idcashier`) REFERENCES `user` (`iduser`),
  CONSTRAINT `FK_dstb_process_user_2` FOREIGN KEY (`iddriver`) REFERENCES `user` (`iduser`),
  CONSTRAINT `FK_dstb_process_user_3` FOREIGN KEY (`idproduction`) REFERENCES `user` (`iduser`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', '14', '5', '3', '4', '2021-07-01 07:37:16', NULL, NULL, '1', 'OT1-01072021-001', '1', '1', 'BARU', NULL, '2021-07-01 07:38:22', 'cashier001', '2021-07-01 07:38:22', 'cashier001', '0');
INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('4', '14', '5', '3', '4', '2021-07-04 00:56:29', NULL, '2024-05-30 10:19:03', '1', 'OT1-04072021-001', '2', '3', 'DIPROSES', NULL, '2021-07-04 00:58:47', 'cashier001', '2021-07-04 00:58:47', 'cashier001', '1');
INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('5', '14', '2', '3', '4', '2022-07-27 19:03:04', '2024-05-03 13:01:13', '2024-05-30 10:18:20', '1', 'OT1-27072022-001', '2', '4', 'DIPROSES', 'Tlg pwehatihan pesan', '2022-07-27 19:04:58', 'administrator', '2022-07-27 19:04:58', 'administrator', '1');
INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('6', '14', '2', '3', '4', '2022-07-27 19:08:37', '2024-05-30 10:24:08', '2024-05-30 10:25:30', '2', 'OT1-27072022-002', '2', '4', 'DIPROSES', 'Kenapa clra dan batman masih ada?', '2022-07-27 19:09:13', 'administrator', '2022-07-27 19:09:13', 'administrator', '1');
INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('7', '14', '10', '9', '4', '2022-07-30 13:41:39', '2023-01-10 06:25:51', '2024-05-04 09:40:30', '1', 'OT1-30072022-001', '0', '0', 'DIPROSES', 'Perhatikan bill ayas nama hari\r\n', '2022-07-30 13:42:28', 'Kasir', '2022-07-30 13:42:28', 'Kasir', '1');
INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('8', '14', '10', '9', '12', '2022-07-30 14:26:08', '2023-01-10 06:48:42', NULL, '2', 'OT1-30072022-002', '0', '0', 'DIJEMPUT', 'PENTING', '2022-07-30 14:26:38', 'Kasir', '2022-07-30 14:26:38', 'Kasir', '1');
INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('9', '14', '7', '9', '12', '2023-12-22 22:59:44', '2024-05-30 10:31:31', NULL, '1', 'OT1-22122023-001', '2', '2', 'DIJEMPUT', 'ok...', '2023-12-22 23:00:51', 'Rudi', '2023-12-22 23:00:51', 'Rudi', '1');
INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('10', '14', '2', '9', '4', '2024-05-01 19:19:17', '2024-05-30 10:34:09', '2024-05-30 10:35:03', '1', 'OT1-01052024-001', '3', '4', 'DIPROSES', 'Perhatikan bill atas mama Toto', '2024-05-01 19:20:01', 'administrator', '2024-05-01 19:20:01', 'administrator', '1');
INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('11', '14', '2', '3', '4', '2024-05-01 21:01:50', '2024-05-30 10:24:46', '2024-05-30 10:26:07', '2', 'OT1-01052024-002', '3', '6', 'DIPROSES', 'Perhatikan Bill atas nama Rudi', '2024-05-01 21:02:14', 'administrator', '2024-05-01 21:02:14', 'administrator', '1');
INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('12', '14', '2', '9', '4', '2024-05-06 07:09:50', '2024-05-30 10:33:11', '2024-05-30 10:35:28', '1', 'OT1-06052024-001', '2', '0', 'DIPROSES', '', '2024-05-06 07:10:32', 'administrator', '2024-05-06 07:10:32', 'administrator', '1');
INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('13', '14', '5', '9', '4', '2024-05-08 01:29:12', '2024-05-30 10:32:34', '2024-05-30 10:35:53', '1', 'OT1-08052024-001', '2', '1', 'DIPROSES', '', '2024-05-08 01:29:33', 'cashier001', '2024-05-08 01:29:33', 'cashier001', '1');
INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('14', '14', '5', '9', '12', '2024-05-11 09:31:08', '2024-05-30 10:32:08', NULL, '1', 'OT1-11052024-001', '2', '3', 'DIJEMPUT', 'Harus segera diproses', '2024-05-11 09:31:46', 'cashier001', '2024-05-11 09:31:46', 'cashier001', '1');
INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('15', '14', '5', '3', '4', '2024-05-31 09:39:05', '2024-05-31 09:41:06', '2024-05-31 09:41:44', '1', 'OT1-31052024-001', '1', '1', 'DIPROSES', '', '2024-05-31 09:39:32', 'cashier001', '2024-05-31 09:39:32', 'cashier001', '1');
INSERT INTO `dstb_process` (`iddstb_process`, `idoutlet`, `idcashier`, `iddriver`, `idproduction`, `dstb_date`, `tgl_dijemput`, `tgl_diproses`, `dstb_number`, `dstb_code`, `total_bill`, `total_pcs`, `dstb_process_status`, `dstb_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('16', '14', '2', '9', '4', '2024-06-02 22:15:35', '2024-06-02 23:00:59', '2024-06-02 23:02:10', '1', 'OT1-02062024-001', '1', '2', 'DIPROSES', '', '2024-06-02 22:16:09', 'administrator', '2024-06-02 22:16:09', 'administrator', '1');


#
# TABLE STRUCTURE FOR: dstb_process_detail
#

DROP TABLE IF EXISTS `dstb_process_detail`;

CREATE TABLE `dstb_process_detail` (
  `iddstb_process_detail` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `iddstb_process` bigint(20) unsigned DEFAULT NULL,
  `idtransaction_group` bigint(20) unsigned DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`iddstb_process_detail`),
  KEY `FK_dstb_process_detail_dstb_process` (`iddstb_process`),
  KEY `FK_dstb_process_detail_transaction_group` (`idtransaction_group`),
  CONSTRAINT `FK_dstb_process_detail_dstb_process` FOREIGN KEY (`iddstb_process`) REFERENCES `dstb_process` (`iddstb_process`),
  CONSTRAINT `FK_dstb_process_detail_transaction_group` FOREIGN KEY (`idtransaction_group`) REFERENCES `transaction_group` (`idtransaction_group`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=latin1;

INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', '3', '41', '2021-07-01 07:38:22', 'cashier001', '2021-07-01 07:38:22', 'cashier001', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', '4', '42', '2021-07-04 00:58:47', 'cashier001', '2021-07-04 00:58:47', 'cashier001', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', '4', '43', '2021-07-04 00:58:47', 'cashier001', '2021-07-04 00:58:47', 'cashier001', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('4', '5', '47', '2022-07-27 19:04:58', 'administrator', '2022-07-27 19:04:58', 'administrator', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('5', '5', '48', '2022-07-27 19:04:58', 'administrator', '2022-07-27 19:04:58', 'administrator', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('6', '6', '47', '2022-07-27 19:09:13', 'administrator', '2022-07-27 19:09:13', 'administrator', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('7', '6', '48', '2022-07-27 19:09:13', 'administrator', '2022-07-27 19:09:13', 'administrator', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('11', '9', '65', '2023-12-22 23:00:51', 'Rudi', '2023-12-22 23:00:51', 'Rudi', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('12', '9', '64', '2023-12-22 23:00:51', 'Rudi', '2023-12-22 23:00:51', 'Rudi', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('13', '10', '45', '2024-05-01 19:20:01', 'administrator', '2024-05-01 19:20:01', 'administrator', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('14', '10', '58', '2024-05-01 19:20:01', 'administrator', '2024-05-01 19:20:01', 'administrator', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('15', '10', '46', '2024-05-01 19:20:01', 'administrator', '2024-05-01 19:20:01', 'administrator', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('16', '11', '55', '2024-05-01 21:02:14', 'administrator', '2024-05-01 21:02:14', 'administrator', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('17', '11', '62', '2024-05-01 21:02:14', 'administrator', '2024-05-01 21:02:14', 'administrator', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('18', '11', '44', '2024-05-01 21:02:14', 'administrator', '2024-05-01 21:02:14', 'administrator', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('19', '12', '31', '2024-05-06 07:10:32', 'administrator', '2024-05-06 07:10:32', 'administrator', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('20', '12', '40', '2024-05-06 07:10:32', 'administrator', '2024-05-06 07:10:32', 'administrator', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('21', '13', '39', '2024-05-08 01:29:33', 'cashier001', '2024-05-08 01:29:33', 'cashier001', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('22', '13', '70', '2024-05-08 01:29:33', 'cashier001', '2024-05-08 01:29:33', 'cashier001', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('23', '14', '72', '2024-05-11 09:31:46', 'cashier001', '2024-05-11 09:31:46', 'cashier001', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('24', '14', '56', '2024-05-11 09:31:46', 'cashier001', '2024-05-11 09:31:46', 'cashier001', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('25', '15', '76', '2024-05-31 09:39:32', 'cashier001', '2024-05-31 09:39:32', 'cashier001', '1');
INSERT INTO `dstb_process_detail` (`iddstb_process_detail`, `iddstb_process`, `idtransaction_group`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('26', '16', '77', '2024-06-02 22:16:09', 'administrator', '2024-06-02 22:16:09', 'administrator', '1');


#
# TABLE STRUCTURE FOR: hue
#

DROP TABLE IF EXISTS `hue`;

CREATE TABLE `hue` (
  `idhue` int(11) NOT NULL AUTO_INCREMENT,
  `hue_name` varchar(50) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idhue`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;

INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', 'Batik', '2021-01-16 16:31:33', 'superadmin', '2021-01-16 16:31:33', 'superadmin', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', 'Garis-garis', '2021-01-16 16:31:39', 'superadmin', '2021-01-16 16:31:39', 'superadmin', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', 'Polos', '2021-04-21 00:24:46', 'administrator', '2021-04-21 00:24:46', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('4', 'Rumbai', '2021-04-21 00:25:02', 'administrator', '2021-04-21 00:25:02', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('5', 'Bunga', '2021-04-21 00:25:22', 'administrator', '2021-04-21 00:25:22', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('6', 'Garis', '2021-04-21 00:25:32', 'administrator', '2021-04-21 00:25:32', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('7', 'Liris', '2021-04-21 00:25:42', 'administrator', '2021-04-21 00:25:42', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('8', 'Kotak2', '2021-04-21 00:25:53', 'administrator', '2021-04-21 00:25:53', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('9', 'Abstrak', '2021-04-21 00:26:16', 'administrator', '2021-04-21 00:26:16', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('10', 'Sablon', '2021-04-21 00:26:26', 'administrator', '2021-04-21 00:26:26', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('11', 'Serat_nenas', '2021-04-21 00:27:05', 'administrator', '2021-04-21 00:27:05', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('12', 'Gambar', '2021-04-21 00:27:20', 'administrator', '2021-04-21 00:27:20', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('13', 'Wol', '2021-04-21 00:27:36', 'administrator', '2021-04-21 00:27:36', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('14', 'Satin', '2021-04-21 00:27:52', 'administrator', '2021-04-21 00:27:52', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('15', 'Katun', '2021-04-21 00:28:07', 'administrator', '2021-04-21 00:28:07', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('16', 'Sintetis', '2021-04-21 00:28:25', 'administrator', '2021-04-21 00:28:25', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('17', 'Karet', '2021-04-21 00:28:39', 'administrator', '2021-04-21 00:28:39', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('18', 'Kulit_hewan', '2021-04-21 00:28:56', 'administrator', '2021-04-21 00:28:56', 'administrator', '1');
INSERT INTO `hue` (`idhue`, `hue_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('19', 'Bordir', '2021-04-21 00:29:08', 'administrator', '2021-04-21 00:29:08', 'administrator', '1');


#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `iditem` bigint(20) NOT NULL AUTO_INCREMENT,
  `idproduct` int(11) DEFAULT NULL,
  `idcustomer` int(11) DEFAULT NULL,
  `item_code` varchar(200) DEFAULT NULL,
  `item_code_num` int(11) DEFAULT NULL,
  `idcolour` varchar(200) DEFAULT NULL,
  `idhue` varchar(200) DEFAULT NULL,
  `photo1` text,
  `photo2` text,
  `photo3` text,
  `photo4` text,
  `photo5` text,
  `photo6` text,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`iditem`),
  KEY `FK_item_product` (`idproduct`),
  KEY `FK_item_customer` (`idcustomer`),
  KEY `FK_item_colour` (`idcolour`),
  KEY `FK_item_hue` (`idhue`),
  CONSTRAINT `FK_item_customer` FOREIGN KEY (`idcustomer`) REFERENCES `customer` (`idcustomer`),
  CONSTRAINT `FK_item_product` FOREIGN KEY (`idproduct`) REFERENCES `product` (`idproduct`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=latin1;

INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', '33', '31', 'B-OT1-00001', '1', '1,2', '1,2', '2ac2d045d5999a68685b6b8a3a4cf797.jpg', 'e656bcbea0a538ab0c0444f247e1c8eb.png', '5a7564d3b1c48f026880f604cc53ba51.png', '08c44835b08a23b74a1292e34de06971.jpg', 'b13dee85fc79c428c7ce8b0b4ca9214a.png', 'eecc9b4b97c3c681f197da72f5d80f43.jpg', '2021-03-04 04:16:47', 'superadmin', '2023-02-06 23:47:16', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('5', '33', '32', 'B-OT1-00002', '2', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-18 20:38:15', 'superadmin', '2023-02-06 15:29:28', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('6', '33', '34', 'B-OT1-00003', '3', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-19 11:05:29', 'cashier001', '2021-04-19 11:15:25', 'cashier001', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('7', '31', '35', 'B-OT1-00004', '4', '2', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-19 11:24:48', 'cashier001', '2023-02-15 11:29:50', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('8', '31', '35', 'B-OT1-00005', '5', '2', '1', '49cdb64f2e12449dfced2f8aa39f9de6.png', '8fa4041a3f7bdc23437f9d9e69079d9e.png', 'fc312f89ea8d700710334bdf835963e2.png', '44863f534fbb88fdd5a422d4971437e1.jpg', '52aff24e12ee5d35ff7494327642c4d4.jpg', 'bc3d55d429379d20f86f3aeefe9d0b21.jpg', '2021-04-19 11:26:03', 'cashier001', '2023-01-12 07:26:46', 'Rudi', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('9', '31', '36', 'B-OT1-00006', '6', '2', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-19 12:19:32', 'cashier001', '2022-07-27 17:42:36', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('10', '33', '36', 'B-OT1-00007', '7', '2', '1', '4a4edb7342e6d25aa299ae3951dc3fa6.jpg', NULL, NULL, NULL, NULL, NULL, '2021-04-19 12:20:27', 'cashier001', '2022-07-27 17:42:36', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('11', '41', '38', 'B-OT2-00001', '1', '17', '2', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 00:53:48', 'administrator', '2021-04-21 00:57:14', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('12', '41', '38', 'B-OT2-00002', '2', '3', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 00:55:36', 'administrator', '2021-04-21 00:57:14', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('13', '42', '39', 'B-OT2-00003', '3', '3', '3', 'aef95debf8f6527ba0e417b6ae70ca30.jpg', '602e0aa2481ed3f68cd306a2f3d63df8.jpg', NULL, NULL, NULL, NULL, '2021-04-21 01:09:52', 'administrator', '2021-04-21 01:11:12', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('14', '42', '39', 'B-OT2-00004', '4', '6', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:10:26', 'administrator', '2021-04-21 01:11:12', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('15', '41', '40', 'B-OT2-00005', '5', '2', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:13:43', 'administrator', '2021-04-21 01:22:46', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('16', '41', '40', 'B-OT2-00006', '6', '6', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:14:03', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('17', '41', '40', 'B-OT2-00007', '7', '14', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:14:36', 'administrator', '2021-04-21 01:14:36', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('18', '43', '40', 'B-OT2-00008', '8', '5', '6', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:15:15', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('19', '42', '40', 'B-OT2-00009', '9', '5', '6', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:15:32', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('20', '43', '40', 'B-OT2-00010', '10', '4', '6', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:16:01', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('21', '41', '40', 'B-OT2-00011', '11', '4', '4', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:16:35', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('22', '41', '40', 'B-OT2-00012', '12', '2', '4', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:16:59', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('23', '42', '40', 'B-OT2-00013', '13', '17', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:17:50', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('24', '42', '40', 'B-OT2-00014', '14', '8', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:18:45', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('25', '42', '40', 'B-OT2-00015', '15', '2', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:19:40', 'administrator', '2021-04-21 01:19:40', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('26', '43', '38', 'B-OT2-00016', '16', '5', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-22 15:22:24', 'administrator', '2021-04-22 15:26:55', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('27', '43', '38', 'B-OT2-00017', '17', '2', '1', '76c987205e92146fef28f29cdb87f914.png', 'd955cc3efdcdb994002df7db78ce516d.png', '29229c142473065654014beec2f38e89.png', NULL, NULL, NULL, '2021-04-22 15:23:37', 'administrator', '2021-04-22 15:26:55', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('28', '34', '37', 'B-OT1-00008', '8', '4', '5', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-22 15:55:59', 'cashier001', '2023-02-08 16:14:46', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('29', '40', '36', 'B-OT1-00009', '9', '2', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-24 06:43:33', 'administrator', '2022-07-27 17:42:36', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('30', '32', '31', 'B-OT1-00010', '10', '3', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2021-07-04 00:53:04', 'cashier001', '2021-07-04 00:53:18', 'cashier001', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('31', '40', '43', 'B-OT1-00011', '11', '4', '13', NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-18 23:49:52', 'Rudi', '2022-07-27 17:46:05', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('32', '32', '43', 'B-OT1-00012', '12', '3', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-18 23:51:49', 'Rudi', '2023-12-22 22:57:53', 'Rudi', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('33', '38', '43', 'B-OT1-00013', '13', '6', '6', NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-18 23:52:37', 'Rudi', '2022-07-27 17:46:05', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('34', '40', '44', 'B-OT1-00014', '14', '2', '5', NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-19 00:00:00', 'Rudi', '2022-07-27 17:37:31', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('35', '34', '45', 'B-OT1-00015', '15', '2', '10', NULL, NULL, NULL, NULL, NULL, NULL, '2021-08-19 00:02:46', 'Rudi', '2021-08-19 00:05:08', 'Rudi', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('36', '40', '35', 'B-OT1-00016', '16', '3', '4', NULL, NULL, NULL, NULL, NULL, NULL, '2022-07-27 10:07:31', 'administrator', '2023-01-12 07:26:46', 'Rudi', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('37', '32', '37', 'B-OT1-00017', '17', '3', '4,5', NULL, NULL, NULL, NULL, NULL, NULL, '2023-02-08 16:13:15', 'administrator', '2023-02-08 16:14:46', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('38', '34', '36', 'B-OT1-00018', '18', '4', '5', NULL, NULL, NULL, NULL, NULL, NULL, '2023-02-11 01:58:02', 'administrator', '2023-02-11 02:01:23', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('39', '35', '36', 'B-OT1-00019', '19', '5', '4', NULL, NULL, NULL, NULL, NULL, NULL, '2023-02-11 02:00:12', 'administrator', '2023-02-11 02:01:23', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('40', '32', '32', 'B-OT1-00020', '20', '3', '2', NULL, NULL, NULL, NULL, NULL, NULL, '2023-02-13 13:05:23', 'administrator', '2024-05-14 09:56:04', 'cashier001', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('41', '45', '33', 'B-OT1-00021', '21', '4', '5', NULL, NULL, NULL, NULL, NULL, NULL, '2023-02-13 14:14:07', 'administrator', '2023-12-20 18:41:58', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('42', '38', '33', 'B-OT1-00022', '22', '5', '6', NULL, NULL, NULL, NULL, NULL, NULL, '2023-02-13 14:17:11', 'administrator', '2023-12-22 22:58:48', 'Rudi', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('43', '40', '44', 'B-OT1-00023', '23', '4', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2023-02-14 10:22:12', 'administrator', '2023-02-14 10:23:58', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('44', '37', '44', 'B-OT1-00024', '24', '3', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2023-02-14 10:22:58', 'administrator', '2023-02-14 10:23:58', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('45', '39', '33', 'B-OT1-00025', '25', '2', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2023-02-14 19:36:24', 'administrator', '2023-02-21 09:33:49', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('46', '40', '41', 'B-OT1-00026', '26', '3', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2023-02-14 20:41:12', 'administrator', '2023-12-20 09:30:17', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('47', '45', '35', 'B-OT1-00027', '27', '3', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2023-02-21 09:36:10', 'administrator', '2023-02-21 09:36:30', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('48', '37', '33', 'B-OT1-00028', '28', '4', '2', NULL, NULL, NULL, NULL, NULL, NULL, '2023-12-20 18:40:29', 'administrator', '2023-12-20 18:41:58', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('49', '32', '35', 'B-OT1-00029', '29', '2', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2024-05-03 22:57:36', 'administrator', '2024-05-10 01:54:30', 'cashier001', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('50', '39', '35', 'B-OT1-00030', '30', '3', '7,8', NULL, NULL, NULL, NULL, NULL, NULL, '2024-05-03 22:59:03', 'administrator', '2024-05-04 19:35:14', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('51', '45', '47', 'B-OT1-00031', '31', '3,6', '2,4', NULL, NULL, NULL, NULL, NULL, NULL, '2024-05-06 22:44:25', 'cashier001', '2024-05-06 22:49:28', 'cashier001', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('52', '43', '38', 'B-OT2-00018', '18', '2', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2024-05-09 23:15:06', 'administrator', '2024-05-09 23:16:46', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('53', '37', '33', 'B-OT1-00032', '32', '3', '4', NULL, NULL, NULL, NULL, NULL, NULL, '2024-05-11 01:13:36', 'administrator', '2024-05-11 01:13:57', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('54', '37', '44', 'B-OT1-00033', '33', '3', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2024-05-14 09:57:41', 'cashier001', '2024-06-01 19:14:34', 'cashier001', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('55', '32', '44', 'B-OT1-00034', '34', '3', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2024-05-14 09:58:44', 'cashier001', '2024-05-14 09:58:44', 'cashier001', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('56', '40', '32', 'B-OT1-00035', '35', '3', '1', NULL, NULL, NULL, NULL, NULL, NULL, '2024-05-31 06:39:28', 'administrator', '2024-05-31 06:39:49', 'administrator', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('57', '31', '35', 'B-OT1-00036', '36', '3', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2024-05-31 09:27:34', 'cashier001', '2024-05-31 09:30:14', 'cashier001', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('58', '31', '44', 'B-OT1-00037', '37', '3', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2024-06-01 19:12:05', 'cashier001', '2024-06-01 19:14:34', 'cashier001', '1');
INSERT INTO `item` (`iditem`, `idproduct`, `idcustomer`, `item_code`, `item_code_num`, `idcolour`, `idhue`, `photo1`, `photo2`, `photo3`, `photo4`, `photo5`, `photo6`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('59', '38', '44', 'B-OT1-00038', '38', '4', '3', NULL, NULL, NULL, NULL, NULL, NULL, '2024-06-04 03:26:05', 'cashier001', '2024-06-04 03:27:39', 'cashier001', '1');


#
# TABLE STRUCTURE FOR: outlay
#

DROP TABLE IF EXISTS `outlay`;

CREATE TABLE `outlay` (
  `idoutlay` int(11) NOT NULL AUTO_INCREMENT,
  `idoutlet` int(11) DEFAULT NULL,
  `idoutlay_type` int(11) DEFAULT NULL,
  `iduser` int(11) DEFAULT NULL,
  `total` double DEFAULT NULL,
  `description` text,
  `datetime` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idoutlay`),
  KEY `FK__outlay_type` (`idoutlay_type`),
  KEY `FK_outlay_outlet` (`idoutlet`),
  KEY `FK_outlay_user` (`iduser`),
  CONSTRAINT `FK_outlay_outlet` FOREIGN KEY (`idoutlet`) REFERENCES `outlet` (`idoutlet`),
  CONSTRAINT `FK_outlay_user` FOREIGN KEY (`iduser`) REFERENCES `user` (`iduser`),
  CONSTRAINT `FK__outlay_type` FOREIGN KEY (`idoutlay_type`) REFERENCES `outlay_type` (`idoutlay_type`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `outlay` (`idoutlay`, `idoutlet`, `idoutlay_type`, `iduser`, `total`, `description`, `datetime`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', '14', '11', '2', '50000', 'Diambil Tito', '2022-07-27 17:48:44', '2022-07-27 17:49:18', 'administrator', '2022-07-27 17:49:18', 'administrator', '1');
INSERT INTO `outlay` (`idoutlay`, `idoutlet`, `idoutlay_type`, `iduser`, `total`, `description`, `datetime`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', '14', '11', '7', '80000', 'Diterima Anto', '2023-01-12 07:16:59', '2023-01-12 07:17:50', 'Rudi', '2023-01-12 07:17:50', 'Rudi', '1');
INSERT INTO `outlay` (`idoutlay`, `idoutlet`, `idoutlay_type`, `iduser`, `total`, `description`, `datetime`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', '14', '11', '2', '80000', '', '2023-12-20 18:52:57', '2023-12-20 18:53:11', 'administrator', '2023-12-20 18:53:11', 'administrator', '1');
INSERT INTO `outlay` (`idoutlay`, `idoutlet`, `idoutlay_type`, `iduser`, `total`, `description`, `datetime`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('4', '14', '11', '2', '80000', '', '2023-12-23 16:27:31', '2023-12-23 16:27:58', 'administrator', '2023-12-23 16:27:58', 'administrator', '1');


#
# TABLE STRUCTURE FOR: outlay_type
#

DROP TABLE IF EXISTS `outlay_type`;

CREATE TABLE `outlay_type` (
  `idoutlay_type` int(11) NOT NULL AUTO_INCREMENT,
  `outlay_type_name` varchar(200) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idoutlay_type`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

INSERT INTO `outlay_type` (`idoutlay_type`, `outlay_type_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('10', 'Foto Copy', '2017-07-08 00:55:48', 'administrator', '2017-07-08 00:55:48', 'administrator', '1');
INSERT INTO `outlay_type` (`idoutlay_type`, `outlay_type_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('11', 'Bensin', '2017-07-08 00:55:53', 'administrator', '2017-07-08 00:55:53', 'administrator', '1');
INSERT INTO `outlay_type` (`idoutlay_type`, `outlay_type_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('12', 'Air Minum', '2017-07-08 00:56:01', 'administrator', '2017-07-08 00:56:01', 'administrator', '1');


#
# TABLE STRUCTURE FOR: outlet
#

DROP TABLE IF EXISTS `outlet`;

CREATE TABLE `outlet` (
  `idoutlet` int(11) NOT NULL AUTO_INCREMENT,
  `outlet_code` varchar(3) DEFAULT NULL,
  `outlet_name` varchar(200) DEFAULT NULL,
  `address` varchar(300) DEFAULT NULL,
  `phone` varchar(200) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idoutlet`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

INSERT INTO `outlet` (`idoutlet`, `outlet_code`, `outlet_name`, `address`, `phone`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('14', 'OT1', 'Laundry Pertama', 'Jl. Indonesia Raya', '08123123123', '2017-07-04 00:36:05', 'superadmin', '2017-07-04 00:36:05', 'superadmin', '1');
INSERT INTO `outlet` (`idoutlet`, `outlet_code`, `outlet_name`, `address`, `phone`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('15', 'OT2', 'Wangi Laundry', 'Surabaya', '08123123123', '2017-07-08 00:13:40', 'administrator', '2017-07-08 00:13:40', 'administrator', '1');
INSERT INTO `outlet` (`idoutlet`, `outlet_code`, `outlet_name`, `address`, `phone`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('16', '005', 'OUTLET CD', 'Medan', '', '2024-05-06 07:03:44', 'administrator', '2024-05-06 07:04:18', 'administrator', '1');


#
# TABLE STRUCTURE FOR: payment_type
#

DROP TABLE IF EXISTS `payment_type`;

CREATE TABLE `payment_type` (
  `idpayment_type` int(11) NOT NULL AUTO_INCREMENT,
  `payment_type_name` varchar(50) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idpayment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `payment_type` (`idpayment_type`, `payment_type_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', 'TUNAI', '2021-03-30 03:22:37', 'superadmin', '2021-03-30 03:22:37', 'superadmin', '1');
INSERT INTO `payment_type` (`idpayment_type`, `payment_type_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', 'DEBET BCA', '2021-03-30 03:22:43', 'superadmin', '2021-03-30 03:22:43', 'superadmin', '1');
INSERT INTO `payment_type` (`idpayment_type`, `payment_type_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', 'OVO', '2021-04-21 00:31:03', 'administrator', '2021-04-21 00:31:03', 'administrator', '1');
INSERT INTO `payment_type` (`idpayment_type`, `payment_type_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('4', 'EDC BNI', '2021-04-21 00:31:27', 'administrator', '2021-04-21 00:31:27', 'administrator', '1');


#
# TABLE STRUCTURE FOR: product
#

DROP TABLE IF EXISTS `product`;

CREATE TABLE `product` (
  `idproduct` int(11) NOT NULL AUTO_INCREMENT,
  `idoutlet` int(11) DEFAULT NULL,
  `product_type` varchar(50) DEFAULT NULL COMMENT 'UNIT/KILOGRAM',
  `product_code` varchar(200) DEFAULT NULL,
  `product_name` varchar(200) DEFAULT NULL,
  `description` text,
  `sell_price` double DEFAULT NULL,
  `b_l` varchar(2) DEFAULT 'B' COMMENT 'B/L',
  `point_a` int(11) DEFAULT NULL,
  `point_b` int(11) DEFAULT NULL,
  `point_c` int(11) DEFAULT NULL,
  `point_d` int(11) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idproduct`),
  KEY `FK_product_outlet` (`idoutlet`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=latin1;

INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('31', '14', 'KILOGRAM', 'ck', 'Jas', '', '50000', 'B', NULL, NULL, NULL, NULL, '2017-10-22 12:29:01', 'administrator', '2021-03-04 03:23:17', 'superadmin', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('32', '14', NULL, NULL, 'Celana', '', '25000', 'B', NULL, NULL, NULL, NULL, '2021-03-04 03:23:23', 'superadmin', '2021-03-04 03:23:23', 'superadmin', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('33', '14', NULL, NULL, 'Baju', '', '12500', 'B', NULL, NULL, NULL, NULL, '2021-03-04 03:23:31', 'superadmin', '2023-02-06 23:43:21', 'administrator', '0');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('34', '14', NULL, NULL, 'Kebaya', '', '15000', 'B', NULL, NULL, NULL, NULL, '2021-04-21 00:32:22', 'administrator', '2021-04-21 00:32:22', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('35', '14', NULL, NULL, 'Kebaya payet', '', '18000', 'B', NULL, NULL, NULL, NULL, '2021-04-21 00:32:40', 'administrator', '2021-04-21 00:32:40', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('36', '14', NULL, NULL, 'Celana pendek', '', '7000', 'B', NULL, NULL, NULL, NULL, '2021-04-21 00:45:33', 'administrator', '2021-04-21 00:45:33', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('37', '14', NULL, NULL, 'Celana Panjang', '', '9000', 'B', '10', '10', '5', '5', '2021-04-21 00:46:07', 'administrator', '2024-05-11 01:13:09', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('38', '14', NULL, NULL, 'Kaos', '', '7000', 'B', NULL, NULL, NULL, NULL, '2021-04-21 00:46:21', 'administrator', '2021-04-21 00:46:21', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('39', '14', NULL, NULL, 'Kemeja', '', '7000', 'B', NULL, NULL, NULL, NULL, '2021-04-21 00:46:40', 'administrator', '2021-04-21 00:46:40', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('40', '14', NULL, NULL, 'Batik', '', '15000', 'B', NULL, NULL, NULL, NULL, '2021-04-21 00:46:56', 'administrator', '2023-01-19 00:35:15', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('41', '15', NULL, NULL, 'Kemeja', '', '7000', 'B', NULL, NULL, NULL, NULL, '2021-04-21 00:52:37', 'administrator', '2023-02-06 23:43:15', 'administrator', '0');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('42', '15', NULL, NULL, 'Jas', '', '12000', 'B', NULL, NULL, NULL, NULL, '2021-04-21 01:06:04', 'administrator', '2021-04-21 01:06:04', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('43', '15', NULL, NULL, 'Batik', '', '10000', 'B', NULL, NULL, NULL, NULL, '2021-04-21 01:06:23', 'administrator', '2021-04-21 01:06:23', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('44', '15', NULL, NULL, 'Kemeja', '', '7000', 'B', NULL, NULL, NULL, NULL, '2021-04-21 01:06:39', 'administrator', '2021-04-21 01:06:39', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('45', '14', NULL, NULL, 'Bed  cover', '', '25000', 'L', NULL, NULL, NULL, NULL, '2021-06-18 04:20:23', 'administrator', '2021-06-18 04:20:23', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('46', '14', NULL, NULL, 'Celana Pendek', '', '9000', 'B', NULL, NULL, NULL, NULL, '2024-05-03 00:29:03', 'administrator', '2024-05-03 00:29:03', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('47', '16', NULL, NULL, 'Jas', '', '3500', 'B', NULL, NULL, NULL, NULL, '2024-05-06 07:57:01', 'administrator', '2024-05-06 08:32:00', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('48', '16', NULL, NULL, 'Safari', '', '3400', 'B', NULL, NULL, NULL, NULL, '2024-05-06 08:04:45', 'administrator', '2024-05-06 08:04:45', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('49', '14', NULL, NULL, 'Dress', '', '3200', 'B', NULL, NULL, NULL, NULL, '2024-05-06 08:08:14', 'administrator', '2024-05-06 08:08:14', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('50', '16', NULL, NULL, 'Dress', '', '3200', 'B', NULL, NULL, NULL, NULL, '2024-05-06 08:09:50', 'administrator', '2024-05-06 08:09:50', 'administrator', '1');
INSERT INTO `product` (`idproduct`, `idoutlet`, `product_type`, `product_code`, `product_name`, `description`, `sell_price`, `b_l`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('51', '16', NULL, NULL, 'Safari', '', '3400', 'B', NULL, NULL, NULL, NULL, '2024-05-06 08:32:52', 'administrator', '2024-05-06 08:32:52', 'administrator', '1');


#
# TABLE STRUCTURE FOR: role
#

DROP TABLE IF EXISTS `role`;

CREATE TABLE `role` (
  `idrole` int(11) NOT NULL AUTO_INCREMENT,
  `parent` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `title` varchar(100) DEFAULT NULL,
  `description` varchar(200) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idrole`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `role` (`idrole`, `parent`, `name`, `title`, `description`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', '0', 'administrator', 'Administrator', 'Administrator', '2017-03-17 21:42:21', 'superadmin', '2017-03-17 21:42:21', 'superadmin', '1');
INSERT INTO `role` (`idrole`, `parent`, `name`, `title`, `description`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', '0', 'cashier', 'Cashier', 'Cashier', '2017-03-17 21:42:39', 'superadmin', '2017-03-17 21:42:39', 'superadmin', '1');
INSERT INTO `role` (`idrole`, `parent`, `name`, `title`, `description`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', '0', 'driver', 'Driver', 'Driver', NULL, NULL, NULL, NULL, '1');
INSERT INTO `role` (`idrole`, `parent`, `name`, `title`, `description`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('4', '0', 'production', 'Production', 'Production', '2021-04-18 13:22:53', NULL, NULL, NULL, '1');


#
# TABLE STRUCTURE FOR: spot
#

DROP TABLE IF EXISTS `spot`;

CREATE TABLE `spot` (
  `idspot` int(11) NOT NULL AUTO_INCREMENT,
  `spot_name` varchar(50) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idspot`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `spot` (`idspot`, `spot_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', 'Minyak', '2021-03-04 03:16:04', 'superadmin', '2021-03-04 03:16:04', 'superadmin', '1');
INSERT INTO `spot` (`idspot`, `spot_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', 'Karat', '2021-03-04 03:16:08', 'superadmin', '2021-03-04 03:16:08', 'superadmin', '1');
INSERT INTO `spot` (`idspot`, `spot_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', 'Sobek', '2021-04-21 00:29:39', 'administrator', '2021-04-21 00:29:39', 'administrator', '1');
INSERT INTO `spot` (`idspot`, `spot_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('4', 'Benang_ketarik', '2021-04-21 00:30:09', 'administrator', '2021-04-21 00:30:09', 'administrator', '1');
INSERT INTO `spot` (`idspot`, `spot_name`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('5', 'Sisip', '2021-04-21 00:30:28', 'administrator', '2021-04-21 00:30:28', 'administrator', '1');


#
# TABLE STRUCTURE FOR: transaction
#

DROP TABLE IF EXISTS `transaction`;

CREATE TABLE `transaction` (
  `idtransaction` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `idtransaction_group` bigint(20) unsigned DEFAULT NULL,
  `iditem` bigint(20) DEFAULT NULL,
  `idspot` varchar(200) DEFAULT NULL,
  `qty` double DEFAULT NULL,
  `price` double DEFAULT NULL,
  `discount` double DEFAULT NULL,
  `add_cost` double DEFAULT NULL,
  `tax` double DEFAULT NULL,
  `total` double DEFAULT NULL,
  `trx_note` varchar(200) DEFAULT NULL,
  `point_a` int(11) DEFAULT NULL,
  `point_b` int(11) DEFAULT NULL,
  `point_c` int(11) DEFAULT NULL,
  `point_d` int(11) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idtransaction`),
  KEY `FK_transaction_product` (`iditem`),
  KEY `FK_transaction_transaction_group` (`idtransaction_group`),
  CONSTRAINT `FK_transaction_item` FOREIGN KEY (`iditem`) REFERENCES `item` (`iditem`),
  CONSTRAINT `FK_transaction_transaction_group` FOREIGN KEY (`idtransaction_group`) REFERENCES `transaction_group` (`idtransaction_group`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=latin1;

INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('18', '31', '2', '', '1', '7500', NULL, '0', NULL, '7500', '', NULL, NULL, NULL, NULL, '2021-04-19 03:43:17', 'cashier001', '2021-04-19 03:43:17', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('19', '32', '6', '', '1', '7500', NULL, '0', NULL, '7500', '', NULL, NULL, NULL, NULL, '2021-04-19 11:15:25', 'cashier001', '2021-04-19 11:15:25', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('20', '33', '7', '', '1', '50000', NULL, '0', NULL, '50000', 'Hilaangkan bulu', NULL, NULL, NULL, NULL, '2021-04-19 12:13:11', 'cashier001', '2021-04-19 12:13:11', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('21', '33', '8', '1', '1', '50000', NULL, '0', NULL, '50000', 'Berkerut', NULL, NULL, NULL, NULL, '2021-04-19 12:13:11', 'cashier001', '2021-04-19 12:13:11', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('22', '33', '8', '2', '1', '50000', NULL, '0', NULL, '50000', 'Hati2..masih baru', NULL, NULL, NULL, NULL, '2021-04-19 12:13:11', 'cashier001', '2021-04-19 12:13:11', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('23', '34', '11', '3', '1', '7000', NULL, '30000', NULL, '37000', 'Sobek dilengan', NULL, NULL, NULL, NULL, '2021-04-21 00:57:14', 'administrator', '2021-04-21 00:57:14', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('24', '34', '12', '1', '1', '7000', NULL, '20000', NULL, '27000', 'Hilangkan minyak', NULL, NULL, NULL, NULL, '2021-04-21 00:57:14', 'administrator', '2021-04-21 00:57:14', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('25', '35', '13', '', '1', '12000', NULL, '0', NULL, '12000', '', NULL, NULL, NULL, NULL, '2021-04-21 01:11:12', 'administrator', '2021-04-21 01:11:12', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('26', '35', '14', '', '1', '12000', NULL, '0', NULL, '12000', '', NULL, NULL, NULL, NULL, '2021-04-21 01:11:12', 'administrator', '2021-04-21 01:11:12', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('27', '36', '15', '', '1', '7000', NULL, '0', NULL, '7000', '', NULL, NULL, NULL, NULL, '2021-04-21 01:19:57', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('28', '36', '16', '', '1', '7000', NULL, '0', NULL, '7000', '', NULL, NULL, NULL, NULL, '2021-04-21 01:19:57', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('29', '36', '18', '', '1', '10000', NULL, '0', NULL, '10000', '', NULL, NULL, NULL, NULL, '2021-04-21 01:19:57', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('30', '36', '19', '', '1', '12000', NULL, '0', NULL, '12000', '', NULL, NULL, NULL, NULL, '2021-04-21 01:19:57', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('31', '36', '20', '', '1', '10000', NULL, '0', NULL, '10000', '', NULL, NULL, NULL, NULL, '2021-04-21 01:19:57', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('32', '36', '21', '', '1', '7000', NULL, '0', NULL, '7000', '', NULL, NULL, NULL, NULL, '2021-04-21 01:19:57', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('33', '36', '22', '', '1', '7000', NULL, '0', NULL, '7000', '', NULL, NULL, NULL, NULL, '2021-04-21 01:19:57', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('34', '36', '23', '', '1', '12000', NULL, '0', NULL, '12000', '', NULL, NULL, NULL, NULL, '2021-04-21 01:19:57', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('35', '36', '24', '', '1', '12000', NULL, '0', NULL, '12000', '', NULL, NULL, NULL, NULL, '2021-04-21 01:19:57', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('36', '36', '24', '', '1', '12000', NULL, '0', NULL, '12000', '', NULL, NULL, NULL, NULL, '2021-04-21 01:19:57', 'administrator', '2021-04-21 01:19:57', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('37', '37', '15', '', '1', '7000', NULL, '0', NULL, '7000', '', NULL, NULL, NULL, NULL, '2021-04-21 01:22:46', 'administrator', '2021-04-21 01:22:46', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('38', '38', '26', '3', '1', '10000', NULL, '40000', NULL, '50000', '', NULL, NULL, NULL, NULL, '2021-04-22 15:26:55', 'administrator', '2021-04-22 15:26:55', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('39', '38', '27', '', '1', '10000', NULL, '10000', NULL, '20000', '', NULL, NULL, NULL, NULL, '2021-04-22 15:26:55', 'administrator', '2021-04-22 15:26:55', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('40', '39', '28', '3', '1', '15000', NULL, '0', NULL, '15000', '', NULL, NULL, NULL, NULL, '2021-04-22 15:58:31', 'cashier001', '2021-04-22 15:58:31', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('41', '40', '2', '3', '1', '7500', NULL, '0', NULL, '7500', 'tambahan okee', NULL, NULL, NULL, NULL, '2021-06-18 02:58:26', 'administrator', '2021-06-18 02:58:26', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('42', '41', '2', '', '1', '7500', NULL, '0', NULL, '7500', '', NULL, NULL, NULL, NULL, '2021-07-01 07:36:23', 'cashier001', '2021-07-01 07:36:23', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('43', '42', '2', '', '1', '7500', NULL, '0', NULL, '7500', '', NULL, NULL, NULL, NULL, '2021-07-04 00:53:18', 'cashier001', '2021-07-04 00:53:18', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('44', '42', '30', '', '1', '25000', NULL, '0', NULL, '25000', '', NULL, NULL, NULL, NULL, '2021-07-04 00:53:18', 'cashier001', '2021-07-04 00:53:18', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('45', '43', '5', '', '1', '7500', NULL, '0', NULL, '7500', '', NULL, NULL, NULL, NULL, '2021-07-04 00:53:41', 'cashier001', '2021-07-04 00:53:41', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('46', '44', '31', '3', '1', '10000', NULL, '20000', NULL, '30000', 'Tlg disisip', NULL, NULL, NULL, NULL, '2021-08-18 23:56:41', 'Rudi', '2021-08-18 23:56:41', 'Rudi', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('47', '44', '32', '1', '1', '25000', NULL, '0', NULL, '25000', 'Tgl dihilangkan', NULL, NULL, NULL, NULL, '2021-08-18 23:56:41', 'Rudi', '2021-08-18 23:56:41', 'Rudi', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('48', '44', '33', '', '1', '7000', NULL, '0', NULL, '7000', '', NULL, NULL, NULL, NULL, '2021-08-18 23:56:41', 'Rudi', '2021-08-18 23:56:41', 'Rudi', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('49', '45', '34', '', '1', '10000', NULL, '20000', NULL, '30000', '', NULL, NULL, NULL, NULL, '2021-08-19 00:00:59', 'Rudi', '2021-08-19 00:00:59', 'Rudi', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('50', '46', '35', '', '1', '15000', NULL, '0', NULL, '15000', '', NULL, NULL, NULL, NULL, '2021-08-19 00:05:08', 'Rudi', '2021-08-19 00:05:08', 'Rudi', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('51', '47', '36', '1', '1', '10000', NULL, '10000', NULL, '20000', 'Pada lenhan', NULL, NULL, NULL, NULL, '2022-07-27 10:11:20', 'administrator', '2022-07-27 10:11:20', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('52', '47', '8', '', '1', '50000', NULL, '0', NULL, '50000', '', NULL, NULL, NULL, NULL, '2022-07-27 10:11:20', 'administrator', '2022-07-27 10:11:20', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('53', '48', '5', '', '1', '7500', NULL, '0', NULL, '7500', '', NULL, NULL, NULL, NULL, '2022-07-27 17:35:23', 'administrator', '2022-07-27 17:35:23', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('54', '48', '5', '', '1', '7500', NULL, '0', NULL, '7500', '', NULL, NULL, NULL, NULL, '2022-07-27 17:35:23', 'administrator', '2022-07-27 17:35:23', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('55', '49', '34', '', '1', '10000', NULL, '0', NULL, '10000', '', NULL, NULL, NULL, NULL, '2022-07-27 17:37:31', 'administrator', '2022-07-27 17:37:31', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('56', '49', '34', '', '1', '10000', NULL, '0', NULL, '10000', '', NULL, NULL, NULL, NULL, '2022-07-27 17:37:31', 'administrator', '2022-07-27 17:37:31', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('57', '49', '34', '', '1', '10000', NULL, '0', NULL, '10000', '', NULL, NULL, NULL, NULL, '2022-07-27 17:37:31', 'administrator', '2022-07-27 17:37:31', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('58', '50', '9', '', '1', '50000', NULL, '0', NULL, '50000', '', NULL, NULL, NULL, NULL, '2022-07-27 17:42:36', 'administrator', '2022-07-27 17:42:36', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('59', '50', '10', '3', '1', '7500', NULL, '10000', NULL, '17500', '', NULL, NULL, NULL, NULL, '2022-07-27 17:42:36', 'administrator', '2022-07-27 17:42:36', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('60', '50', '29', '', '1', '10000', NULL, '0', NULL, '10000', '', NULL, NULL, NULL, NULL, '2022-07-27 17:42:36', 'administrator', '2022-07-27 17:42:36', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('61', '51', '31', '', '1', '10000', NULL, '10000', NULL, '20000', 'Tolong di warna kan yg bagus', NULL, NULL, NULL, NULL, '2022-07-27 17:46:05', 'administrator', '2022-07-27 17:46:05', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('62', '51', '33', '', '1', '7000', NULL, '0', NULL, '7000', '', NULL, NULL, NULL, NULL, '2022-07-27 17:46:05', 'administrator', '2022-07-27 17:46:05', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('63', '52', '8', '', '1', '50000', NULL, '0', NULL, '50000', '', NULL, NULL, NULL, NULL, '2023-01-12 07:26:46', 'Rudi', '2023-01-12 07:26:46', 'Rudi', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('64', '52', '36', '', '1', '10000', NULL, '0', NULL, '10000', '', NULL, NULL, NULL, NULL, '2023-01-12 07:26:46', 'Rudi', '2023-01-12 07:26:46', 'Rudi', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('65', '53', '5', '', '1', '12500', NULL, '0', NULL, '12500', '', NULL, NULL, NULL, NULL, '2023-02-06 09:35:14', 'administrator', '2023-02-06 09:35:14', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('66', '54', '5', '', '1', '12500', NULL, '0', NULL, '12500', '', NULL, NULL, NULL, NULL, '2023-02-06 15:29:28', 'administrator', '2023-02-06 15:29:28', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('67', '55', '28', '', '1', '15000', NULL, '0', NULL, '15000', '', NULL, NULL, NULL, NULL, '2023-02-08 16:14:46', 'administrator', '2023-02-08 16:14:46', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('68', '55', '37', '', '1', '25000', NULL, '0', NULL, '25000', '', NULL, NULL, NULL, NULL, '2023-02-08 16:14:46', 'administrator', '2023-02-08 16:14:46', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('69', '56', '38', '4', '1', '15000', NULL, '10000', NULL, '25000', 'Lubangnya sebesar uang koin ', NULL, NULL, NULL, NULL, '2023-02-11 02:01:23', 'administrator', '2023-02-11 02:01:23', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('70', '56', '39', '4', '1', '18000', NULL, '0', NULL, '18000', 'Ketarik dibahagian leher', NULL, NULL, NULL, NULL, '2023-02-11 02:01:23', 'administrator', '2023-02-11 02:01:23', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('71', '57', '41', '3', '1', '25000', NULL, '10000', NULL, '35000', 'Tolong disisip yg bagus ya', NULL, NULL, NULL, NULL, '2023-02-13 14:17:58', 'administrator', '2023-02-13 14:17:58', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('72', '57', '42', '', '1', '7000', NULL, '0', NULL, '7000', 'Masih baru', NULL, NULL, NULL, NULL, '2023-02-13 14:17:58', 'administrator', '2023-02-13 14:17:58', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('73', '58', '43', '2', '1', '15000', NULL, '0', NULL, '15000', 'Tolong hilangkan karat nya', NULL, NULL, NULL, NULL, '2023-02-14 10:23:58', 'administrator', '2023-02-14 10:23:58', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('74', '58', '44', '3', '1', '9000', NULL, '0', NULL, '9000', 'Kena rokoko', NULL, NULL, NULL, NULL, '2023-02-14 10:23:58', 'administrator', '2023-02-14 10:23:58', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('75', '59', '7', '', '1', '50000', NULL, '0', NULL, '50000', 'kusut dilengan hilangkan', NULL, NULL, NULL, NULL, '2023-02-15 11:29:50', 'administrator', '2023-02-15 11:29:50', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('76', '60', '45', '4', '1', '7000', NULL, '0', NULL, '7000', 'Bersihkan benangnya', NULL, NULL, NULL, NULL, '2023-02-21 09:33:49', 'administrator', '2023-02-21 09:33:49', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('77', '61', '47', '', '1', '25000', NULL, '0', NULL, '25000', '', NULL, NULL, NULL, NULL, '2023-02-21 09:36:30', 'administrator', '2023-02-21 09:36:30', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('78', '62', '46', '', '1', '15000', NULL, '0', NULL, '15000', '', NULL, NULL, NULL, NULL, '2023-12-20 09:30:17', 'administrator', '2023-12-20 09:30:17', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('79', '63', '41', '', '1', '25000', NULL, '0', NULL, '25000', '', NULL, NULL, NULL, NULL, '2023-12-20 18:41:58', 'administrator', '2023-12-20 18:41:58', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('80', '63', '48', '', '1', '9000', NULL, '0', NULL, '9000', '', NULL, NULL, NULL, NULL, '2023-12-20 18:41:58', 'administrator', '2023-12-20 18:41:58', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('81', '64', '32', '', '1', '25000', NULL, '0', NULL, '25000', '', NULL, NULL, NULL, NULL, '2023-12-22 22:57:53', 'Rudi', '2023-12-22 22:57:53', 'Rudi', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('82', '65', '42', '', '1', '7000', NULL, '0', NULL, '7000', '', NULL, NULL, NULL, NULL, '2023-12-22 22:58:48', 'Rudi', '2023-12-22 22:58:48', 'Rudi', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('83', '66', '40', '', '1', '25000', NULL, '0', NULL, '25000', '', NULL, NULL, NULL, NULL, '2024-04-29 09:54:17', 'administrator', '2024-04-29 09:54:17', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('84', '67', '49', '', '1', '25000', NULL, '0', NULL, '25000', '', NULL, NULL, NULL, NULL, '2024-05-03 23:00:44', 'administrator', '2024-05-03 23:00:44', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('85', '67', '50', '', '1', '7000', NULL, '0', NULL, '7000', '', NULL, NULL, NULL, NULL, '2024-05-03 23:00:44', 'administrator', '2024-05-03 23:00:44', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('86', '68', '49', '', '1', '25000', NULL, '0', NULL, '25000', '', NULL, NULL, NULL, NULL, '2024-05-04 19:33:42', 'administrator', '2024-05-04 19:33:42', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('87', '69', '50', '', '1', '7000', NULL, '0', NULL, '7000', '', NULL, NULL, NULL, NULL, '2024-05-04 19:35:14', 'administrator', '2024-05-04 19:35:14', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('88', '70', '51', '3', '1', '25000', NULL, '0', NULL, '25000', 'mohon disisp', NULL, NULL, NULL, NULL, '2024-05-06 22:49:28', 'cashier001', '2024-05-06 22:49:28', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('89', '71', '52', '', '1', '10000', NULL, '0', NULL, '10000', 'Kalau bermasalah hubungi 086828288282', NULL, NULL, NULL, NULL, '2024-05-09 23:16:46', 'administrator', '2024-05-09 23:16:46', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('90', '72', '49', '', '1', '25000', NULL, '10000', NULL, '35000', '', NULL, NULL, NULL, NULL, '2024-05-10 01:54:30', 'cashier001', '2024-05-10 01:54:30', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('91', '73', '53', '', '1', '9000', NULL, '0', NULL, '9000', '', '10', '10', '5', '5', '2024-05-11 01:13:57', 'administrator', '2024-05-11 01:13:57', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('92', '74', '40', '', '1', '20000', NULL, '0', NULL, '20000', '', NULL, NULL, NULL, NULL, '2024-05-14 09:56:04', 'cashier001', '2024-05-14 09:56:04', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('93', '75', '56', '2', '1', '15000', NULL, '0', NULL, '15000', '', NULL, NULL, NULL, NULL, '2024-05-31 06:39:49', 'administrator', '2024-05-31 06:39:49', 'administrator', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('94', '76', '57', '', '1', '30000', NULL, '0', NULL, '30000', '', NULL, NULL, NULL, NULL, '2024-05-31 09:30:14', 'cashier001', '2024-05-31 09:30:14', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('95', '77', '58', '', '1', '50000', NULL, '0', NULL, '50000', '', NULL, NULL, NULL, NULL, '2024-06-01 19:14:34', 'cashier001', '2024-06-01 19:14:34', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('96', '77', '54', '', '1', '9000', NULL, '0', NULL, '9000', '', '10', '10', '5', '5', '2024-06-01 19:14:34', 'cashier001', '2024-06-01 19:14:34', 'cashier001', '1');
INSERT INTO `transaction` (`idtransaction`, `idtransaction_group`, `iditem`, `idspot`, `qty`, `price`, `discount`, `add_cost`, `tax`, `total`, `trx_note`, `point_a`, `point_b`, `point_c`, `point_d`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('97', '78', '59', '3', '1', '7000', NULL, '10000', NULL, '17000', 'Kalau bermasalah hubungi ', NULL, NULL, NULL, NULL, '2024-06-04 03:27:39', 'cashier001', '2024-06-04 03:27:39', 'cashier001', '1');


#
# TABLE STRUCTURE FOR: transaction_additional_cost
#

DROP TABLE IF EXISTS `transaction_additional_cost`;

CREATE TABLE `transaction_additional_cost` (
  `idtransaction_additional_cost` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `idtransaction` bigint(20) unsigned DEFAULT NULL,
  `idadditional_cost` int(11) DEFAULT NULL,
  `additional_price` double DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idtransaction_additional_cost`),
  KEY `FK_transaction_additional_cost_additional_cost` (`idadditional_cost`),
  KEY `FK_transaction_additional_cost_transaction` (`idtransaction`),
  CONSTRAINT `FK_transaction_additional_cost_additional_cost` FOREIGN KEY (`idadditional_cost`) REFERENCES `additional_cost` (`idadditional_cost`),
  CONSTRAINT `FK_transaction_additional_cost_transaction` FOREIGN KEY (`idtransaction`) REFERENCES `transaction` (`idtransaction`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1;

INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('9', '23', '2', '30000', '2021-04-21 00:57:14', 'administrator', '2021-04-21 00:57:14', 'administrator', '1');
INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('10', '24', '1', '10000', '2021-04-21 00:57:14', 'administrator', '2021-04-21 00:57:14', 'administrator', '1');
INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('11', '24', '2', '10000', '2021-04-21 00:57:14', 'administrator', '2021-04-21 00:57:14', 'administrator', '1');
INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('12', '38', '2', '40000', '2021-04-22 15:26:55', 'administrator', '2021-04-22 15:26:55', 'administrator', '1');
INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('13', '39', '2', '10000', '2021-04-22 15:26:55', 'administrator', '2021-04-22 15:26:55', 'administrator', '1');
INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('14', '46', '2', '20000', '2021-08-18 23:56:41', 'Rudi', '2021-08-18 23:56:41', 'Rudi', '1');
INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('15', '49', '1', '20000', '2021-08-19 00:00:59', 'Rudi', '2021-08-19 00:00:59', 'Rudi', '1');
INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('16', '51', '1', '10000', '2022-07-27 10:11:20', 'administrator', '2022-07-27 10:11:20', 'administrator', '1');
INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('17', '59', '2', '10000', '2022-07-27 17:42:36', 'administrator', '2022-07-27 17:42:36', 'administrator', '1');
INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('18', '61', '1', '10000', '2022-07-27 17:46:05', 'administrator', '2022-07-27 17:46:05', 'administrator', '1');
INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('19', '69', '2', '10000', '2023-02-11 02:01:23', 'administrator', '2023-02-11 02:01:23', 'administrator', '1');
INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('20', '71', '2', '10000', '2023-02-13 14:17:58', 'administrator', '2023-02-13 14:17:58', 'administrator', '1');
INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('21', '90', '1', '10000', '2024-05-10 01:54:30', 'cashier001', '2024-05-10 01:54:30', 'cashier001', '1');
INSERT INTO `transaction_additional_cost` (`idtransaction_additional_cost`, `idtransaction`, `idadditional_cost`, `additional_price`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('22', '97', '1', '10000', '2024-06-04 03:27:39', 'cashier001', '2024-06-04 03:27:39', 'cashier001', '1');


#
# TABLE STRUCTURE FOR: transaction_detail
#

DROP TABLE IF EXISTS `transaction_detail`;

CREATE TABLE `transaction_detail` (
  `idtransaction_detail` int(11) NOT NULL AUTO_INCREMENT,
  `idtransaction_group` bigint(20) unsigned DEFAULT NULL,
  `detail_description` varchar(300) DEFAULT NULL,
  `detail_qty` double DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idtransaction_detail`),
  KEY `FK_transaction_detail_transaction_group` (`idtransaction_group`),
  CONSTRAINT `FK_transaction_detail_transaction_group` FOREIGN KEY (`idtransaction_group`) REFERENCES `transaction_group` (`idtransaction_group`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: transaction_group
#

DROP TABLE IF EXISTS `transaction_group`;

CREATE TABLE `transaction_group` (
  `idtransaction_group` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `idoutlet` int(11) DEFAULT NULL,
  `idcustomer` int(11) DEFAULT NULL,
  `idpayment_type` int(11) DEFAULT NULL,
  `idpayment_type_finish` int(11) DEFAULT NULL,
  `iduser` int(11) DEFAULT NULL,
  `iddriver` int(11) DEFAULT NULL,
  `idproduction` int(11) DEFAULT NULL,
  `iddriver_return` int(11) DEFAULT NULL,
  `idcashier_return` int(11) DEFAULT NULL,
  `idpickup` int(11) DEFAULT NULL,
  `code` varchar(200) DEFAULT NULL,
  `code_num` double DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `duedate` datetime DEFAULT NULL,
  `pay_date` datetime DEFAULT NULL,
  `pickup_date` datetime DEFAULT NULL,
  `grand_total` double DEFAULT NULL,
  `grand_discount` double DEFAULT NULL,
  `grand_discount_percent` double DEFAULT NULL,
  `grand_add_cost` double DEFAULT NULL,
  `grand_tax` double DEFAULT NULL,
  `grand_tax_percent` double DEFAULT NULL,
  `grand_total_final` double DEFAULT NULL,
  `total_pay` double DEFAULT NULL,
  `total_panjar` double DEFAULT NULL,
  `total_pay_finish` double DEFAULT NULL,
  `payment_status` varchar(50) DEFAULT NULL COMMENT 'PANJAR/CASH/BELUM BAYAR',
  `process_status` varchar(50) DEFAULT 'Menunggu Driver' COMMENT 'Menunggu Driver, Penjemputan, Produksi, Pengantaran, Selesai',
  `transaction_group_status` varchar(50) DEFAULT NULL COMMENT 'Baru/St Proses/St Bersih/Pick Up/Selesai',
  `dstb_status` varchar(50) DEFAULT 'BARU' COMMENT 'BARU, DIJEMPUT, PRODUKSI',
  `note` text,
  `hanger_no` varchar(50) DEFAULT NULL,
  `rack` varchar(50) DEFAULT NULL,
  `total_pcs` int(11) DEFAULT NULL,
  `pending_description` varchar(200) DEFAULT NULL,
  `stock_position` varchar(200) DEFAULT NULL,
  `add_cost_note` varchar(200) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`idtransaction_group`),
  UNIQUE KEY `code` (`code`),
  KEY `FK_transaction_group_outlet` (`idoutlet`),
  KEY `FK_transaction_group_customer` (`idcustomer`),
  KEY `FK_transaction_group_user` (`iduser`),
  KEY `FK_transaction_group_payment_type` (`idpayment_type`),
  KEY `FK_transaction_group_user_2` (`iddriver`),
  KEY `FK_transaction_group_user_3` (`idproduction`),
  KEY `FK_transaction_group_user_4` (`iddriver_return`),
  KEY `FK_transaction_group_user_5` (`idcashier_return`),
  KEY `FK_transaction_group_payment_type_2` (`idpayment_type_finish`),
  KEY `FK_transaction_group_user_6` (`idpickup`),
  CONSTRAINT `FK_transaction_group_customer` FOREIGN KEY (`idcustomer`) REFERENCES `customer` (`idcustomer`),
  CONSTRAINT `FK_transaction_group_outlet` FOREIGN KEY (`idoutlet`) REFERENCES `outlet` (`idoutlet`),
  CONSTRAINT `FK_transaction_group_payment_type` FOREIGN KEY (`idpayment_type`) REFERENCES `payment_type` (`idpayment_type`),
  CONSTRAINT `FK_transaction_group_payment_type_2` FOREIGN KEY (`idpayment_type_finish`) REFERENCES `payment_type` (`idpayment_type`),
  CONSTRAINT `FK_transaction_group_user` FOREIGN KEY (`iduser`) REFERENCES `user` (`iduser`),
  CONSTRAINT `FK_transaction_group_user_2` FOREIGN KEY (`iddriver`) REFERENCES `user` (`iduser`),
  CONSTRAINT `FK_transaction_group_user_3` FOREIGN KEY (`idproduction`) REFERENCES `user` (`iduser`),
  CONSTRAINT `FK_transaction_group_user_4` FOREIGN KEY (`iddriver_return`) REFERENCES `user` (`iduser`),
  CONSTRAINT `FK_transaction_group_user_5` FOREIGN KEY (`idcashier_return`) REFERENCES `user` (`iduser`),
  CONSTRAINT `FK_transaction_group_user_6` FOREIGN KEY (`idpickup`) REFERENCES `user` (`iduser`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=latin1;

INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('31', '14', '31', '1', '1', '5', '3', NULL, '3', '5', '2', 'BILLOT1-00001', '1', '2021-04-19 03:43:17', '2021-04-21 17:00:00', '2021-04-19 03:43:17', '2024-06-04 03:34:38', '7500', NULL, NULL, NULL, NULL, NULL, '7500', '10000', '5000', '2500', 'PANJAR', 'Selesai', 'Selesai', 'SELESAI', '', '12', 'b4', NULL, NULL, NULL, NULL, '2021-04-19 03:43:17', 'cashier001', '2024-06-04 03:34:38', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('32', '14', '34', '1', NULL, '5', NULL, NULL, NULL, NULL, '2', 'BILLOT1-00002', '2', '2021-04-19 11:15:25', '2021-04-21 17:00:00', '2021-04-19 11:15:25', NULL, '7500', NULL, NULL, NULL, NULL, NULL, '7500', '10000', '0', NULL, 'CASH', 'Menunggu Driver', 'Selesai', 'BARU', '', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-19 11:15:25', 'cashier001', '2021-04-23 05:53:16', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('33', '14', '35', '1', '1', '5', NULL, NULL, NULL, NULL, '5', 'BILLOT1-00003', '3', '2021-04-19 12:13:11', '2021-04-21 17:00:00', '2021-04-19 12:13:11', NULL, '150000', NULL, NULL, NULL, NULL, NULL, '150000', '100000', '50000', '100000', 'PANJAR', 'Menunggu Driver', 'Selesai', 'BARU', 'Untu bill ini tlg diperhatikan kkerapiannya ya ', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-19 12:13:11', 'cashier001', '2021-04-22 17:19:36', 'cashier001', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('34', '15', '38', '1', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT2-00001', '1', '2021-04-21 00:57:14', '2021-04-23 17:00:00', '2021-04-21 00:57:14', NULL, '64000', NULL, NULL, NULL, NULL, NULL, '64000', '100000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 00:57:14', 'administrator', '2021-04-21 00:57:14', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('35', '15', '39', '1', NULL, '2', '3', NULL, NULL, NULL, NULL, 'BILLOT2-00002', '2', '2021-04-21 01:11:12', '2021-04-23 17:00:00', '2021-04-21 01:11:12', NULL, '24000', NULL, NULL, NULL, NULL, NULL, '24000', '10000', '10000', NULL, 'PANJAR', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:11:12', 'administrator', '2021-04-21 01:33:33', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('36', '15', '40', NULL, NULL, '2', '3', NULL, NULL, NULL, NULL, 'BILLOT2-00003', '3', '2021-04-21 01:19:57', '2021-04-23 17:00:00', '2021-04-21 01:19:57', NULL, '96000', NULL, NULL, NULL, NULL, NULL, '96000', '0', '0', NULL, 'BELUM BAYAR', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:19:57', 'administrator', '2021-04-21 01:32:33', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('37', '15', '40', '1', NULL, '2', '3', NULL, NULL, NULL, NULL, 'BILLOT2-00004', '4', '2021-04-21 01:22:46', '2021-04-23 17:00:00', '2021-04-21 01:22:46', NULL, '7000', NULL, NULL, NULL, NULL, NULL, '7000', '10000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-21 01:22:46', 'administrator', '2021-04-21 01:28:32', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('38', '15', '38', '1', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT2-00005', '5', '2021-04-22 15:26:55', '2021-04-24 17:00:00', '2021-04-22 15:26:55', NULL, '70000', NULL, NULL, NULL, NULL, NULL, '70000', '50000', '30000', NULL, 'PANJAR', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-22 15:26:55', 'administrator', '2021-04-22 15:26:55', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('39', '14', '37', '1', '1', '5', NULL, NULL, NULL, NULL, '2', 'BILLOT1-00004', '4', '2021-04-22 15:58:31', '2021-04-24 17:00:00', '2021-04-22 15:58:31', NULL, '15000', NULL, NULL, NULL, NULL, NULL, '15000', '10000', '10000', '5000', 'PANJAR', 'Menunggu Driver', 'Selesai', 'DIANTAR', '', NULL, NULL, NULL, NULL, NULL, NULL, '2021-04-22 15:58:31', 'cashier001', '2022-07-27 17:56:23', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('40', '14', '31', '2', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00005', '5', '2021-06-18 02:58:26', '2021-06-20 17:00:00', '2021-06-18 02:58:26', NULL, '7500', NULL, NULL, NULL, NULL, NULL, '7500', '7500', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'DIANTAR', '', NULL, NULL, NULL, NULL, NULL, NULL, '2021-06-18 02:58:26', 'administrator', '2021-06-18 02:58:26', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('41', '14', '31', '1', NULL, '5', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00006', '6', '2021-07-01 07:36:23', '2021-07-03 17:00:00', '2021-07-01 07:36:23', NULL, '7500', NULL, NULL, NULL, NULL, NULL, '7500', '10000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, '1', NULL, NULL, NULL, '2021-07-01 07:36:23', 'cashier001', '2021-07-04 00:50:06', 'superadmin', '0');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('42', '14', '31', '1', NULL, '5', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00007', '7', '2021-07-04 00:53:18', '2021-07-06 17:00:00', '2021-07-04 00:53:18', NULL, '32500', NULL, NULL, NULL, NULL, NULL, '32500', '50000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'DIPROSES', '', NULL, NULL, '2', NULL, NULL, NULL, '2021-07-04 00:53:18', 'cashier001', '2021-07-04 00:53:18', 'cashier001', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('43', '14', '32', '1', NULL, '5', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00008', '8', '2021-07-04 00:53:41', '2021-07-06 17:00:00', '2021-07-04 00:53:41', NULL, '7500', NULL, NULL, NULL, NULL, NULL, '7500', '10000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'DIPROSES', '', NULL, NULL, '1', NULL, NULL, NULL, '2021-07-04 00:53:41', 'cashier001', '2021-07-04 00:53:41', 'cashier001', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('44', '14', '43', '1', '1', '7', NULL, NULL, NULL, NULL, '2', 'BILLOT1-00009', '9', '2021-08-18 23:56:41', '2021-08-20 17:00:00', '2021-08-18 23:56:41', NULL, '62000', NULL, NULL, NULL, NULL, NULL, '62000', '50000', '40000', '22000', 'PANJAR', 'Menunggu Driver', 'Selesai', 'DIPROSES', 'Tlg buat yg wangi', NULL, NULL, '3', NULL, NULL, NULL, '2021-08-18 23:56:41', 'Rudi', '2022-07-27 18:00:43', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('45', '14', '44', '1', NULL, '7', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00010', '10', '2021-08-19 00:00:59', '2021-08-20 17:00:00', '2021-08-19 00:00:59', NULL, '30000', NULL, NULL, NULL, NULL, NULL, '30000', '50000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'DIPROSES', 'Buat yg bagus ya', NULL, NULL, '1', NULL, NULL, NULL, '2021-08-19 00:00:59', 'Rudi', '2021-08-19 00:00:59', 'Rudi', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('46', '14', '45', NULL, '1', '7', NULL, NULL, NULL, NULL, '2', 'BILLOT1-00011', '11', '2021-08-19 00:05:08', '2021-08-21 17:00:00', '2021-08-19 00:05:08', NULL, '15000', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '15000', 'BELUM BAYAR', 'Menunggu Driver', 'Selesai', 'DIPROSES', '', NULL, NULL, '1', NULL, NULL, NULL, '2021-08-19 00:05:08', 'Rudi', '2021-08-19 00:13:36', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('47', '14', '35', '1', NULL, '2', '9', NULL, NULL, NULL, NULL, 'BILLOT1-00012', '12', '2022-07-27 10:11:20', '2022-07-29 17:00:00', '2022-07-27 10:11:20', NULL, '70000', NULL, NULL, NULL, NULL, NULL, '70000', '50000', '20000', NULL, 'PANJAR', 'Penjemputan', 'St Proses', 'DIPROSES', '', NULL, NULL, '2', 'Masih kotor', NULL, NULL, '2022-07-27 10:11:20', 'administrator', '2022-07-30 14:38:33', 'Risky', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('48', '14', '32', '1', NULL, '2', '3', NULL, NULL, NULL, '5', 'BILLOT1-00013', '13', '2022-07-27 17:35:23', '2022-07-29 17:00:00', '2022-07-27 17:35:23', '2024-06-04 08:16:16', '15000', NULL, NULL, NULL, NULL, NULL, '15000', '20000', '0', NULL, 'CASH', 'Penjemputan', 'Selesai', 'SELESAI', '', NULL, NULL, '2', NULL, NULL, NULL, '2022-07-27 17:35:23', 'administrator', '2024-06-04 08:16:16', 'cashier001', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('49', '14', '44', NULL, NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00014', '14', '2022-07-27 17:37:31', '2022-07-29 17:00:00', '2022-07-27 17:37:31', NULL, '30000', NULL, NULL, NULL, NULL, NULL, '30000', '0', '0', NULL, 'BELUM BAYAR', 'Menunggu Driver', 'Baru', 'DIJEMPUT', '', NULL, NULL, '3', NULL, NULL, NULL, '2022-07-27 17:37:31', 'administrator', '2022-07-27 17:37:31', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('50', '14', '36', '3', '1', '2', '9', NULL, '9', '7', '2', 'BILLOT1-00015', '15', '2022-07-27 17:42:36', '2022-07-29 17:00:00', '2022-07-27 17:42:36', '2024-05-14 10:16:09', '77500', NULL, NULL, NULL, NULL, NULL, '77500', '50000', '50000', '27500', 'PANJAR', 'Selesai', 'Selesai', 'DIANTAR', '', 'A', '', '3', 'Belum selesai', NULL, NULL, '2022-07-27 17:42:36', 'administrator', '2024-05-14 10:16:09', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('51', '14', '43', '4', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00016', '16', '2022-07-27 17:46:05', '2022-07-29 17:00:00', '2022-07-27 17:46:05', NULL, '27000', NULL, NULL, NULL, NULL, NULL, '27000', '27000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'DIJEMPUT', 'Semua pakaian dilipat ', NULL, NULL, '2', NULL, NULL, NULL, '2022-07-27 17:46:05', 'administrator', '2022-07-27 17:46:05', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('52', '14', '35', '1', NULL, '7', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00017', '17', '2023-01-12 07:26:46', '2023-01-14 17:00:00', '2023-01-12 07:26:46', NULL, '60000', NULL, NULL, NULL, NULL, NULL, '60000', '100000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, '2', NULL, NULL, NULL, '2023-01-12 07:26:46', 'Rudi', '2023-01-12 07:26:46', 'Rudi', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('53', '14', '32', NULL, NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00018', '18', '2023-02-06 09:35:14', '2023-02-08 17:00:00', '2023-02-06 09:35:14', NULL, '12500', NULL, NULL, NULL, NULL, NULL, '12500', '0', '0', NULL, 'BELUM BAYAR', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, '1', NULL, NULL, NULL, '2023-02-06 09:35:14', 'administrator', '2023-02-06 09:35:14', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('54', '14', '32', '1', NULL, '2', NULL, NULL, NULL, NULL, '2', 'BILLOT1-00019', '19', '2023-02-06 15:29:28', '2023-02-08 17:00:00', '2023-02-06 15:29:28', NULL, '12500', NULL, NULL, NULL, NULL, NULL, '12500', '15000', '0', NULL, 'CASH', 'Menunggu Driver', 'Selesai', 'BARU', '', NULL, NULL, '1', NULL, NULL, NULL, '2023-02-06 15:29:28', 'administrator', '2023-02-08 09:32:55', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('55', '14', '37', '1', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00020', '20', '2023-02-08 16:14:46', '2023-02-10 17:00:00', '2023-02-08 16:14:46', NULL, '40000', NULL, NULL, NULL, NULL, NULL, '40000', '50000', '10000', NULL, 'PANJAR', 'Menunggu Driver', 'Baru', 'DIPROSES', '', NULL, NULL, '2', NULL, NULL, NULL, '2023-02-08 16:14:46', 'administrator', '2023-02-08 16:14:46', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('56', '14', '36', '1', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00021', '21', '2023-02-11 02:01:23', '2023-02-13 17:00:00', '2023-02-11 02:01:23', NULL, '43000', NULL, NULL, NULL, NULL, NULL, '43000', '50000', '20000', NULL, 'PANJAR', 'Menunggu Driver', 'Baru', 'DIJEMPUT', 'Tolong dibuat yang wangi ', NULL, NULL, '2', NULL, NULL, NULL, '2023-02-11 02:01:23', 'administrator', '2023-02-11 02:01:23', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('57', '14', '33', '1', '1', '2', NULL, NULL, NULL, NULL, '2', 'BILLOT1-00022', '22', '2023-02-13 14:17:58', '2023-02-15 17:00:00', '2023-02-13 14:17:58', '2023-02-21 11:14:41', '42000', NULL, NULL, NULL, NULL, NULL, '42000', '50000', '10000', '32000', 'PANJAR', 'Menunggu Driver', 'Selesai', 'BARU', 'Buat wangi emua', NULL, NULL, '2', NULL, NULL, NULL, '2023-02-13 14:17:58', 'administrator', '2023-02-21 11:14:41', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('58', '14', '44', '1', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00023', '23', '2023-02-14 10:23:58', '2023-02-16 17:00:00', '2023-02-14 10:23:58', NULL, '24000', NULL, NULL, NULL, NULL, NULL, '24000', '50000', '20000', NULL, 'PANJAR', 'Menunggu Driver', 'Baru', 'DIPROSES', 'Tolong dibuat wangi ya', NULL, NULL, '2', NULL, NULL, NULL, '2023-02-14 10:23:58', 'administrator', '2023-02-14 10:23:58', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('59', '14', '35', '1', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00024', '24', '2023-02-15 11:29:50', '2023-02-17 17:00:00', '2023-02-15 11:29:50', NULL, '50000', NULL, NULL, NULL, NULL, NULL, '50000', '50000', '20000', NULL, 'PANJAR', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, '1', NULL, NULL, NULL, '2023-02-15 11:29:50', 'administrator', '2023-02-15 11:29:50', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('60', '14', '33', '4', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00025', '25', '2023-02-21 09:33:49', '2023-02-23 17:00:00', '2023-02-21 09:33:49', NULL, '7000', NULL, NULL, NULL, NULL, NULL, '7000', '7000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'BARU', 'Wangi ya', NULL, NULL, '1', NULL, NULL, NULL, '2023-02-21 09:33:49', 'administrator', '2023-02-21 09:33:49', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('61', '14', '35', '1', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00026', '26', '2023-02-21 09:36:30', '2023-02-23 17:00:00', '2023-02-21 09:36:30', NULL, '25000', NULL, NULL, NULL, NULL, NULL, '25000', '20000', '10000', NULL, 'PANJAR', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, '1', NULL, NULL, NULL, '2023-02-21 09:36:30', 'administrator', '2023-02-21 09:36:30', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('62', '14', '41', '1', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00027', '27', '2023-12-20 09:30:17', '2023-12-22 17:00:00', '2023-12-20 09:30:17', NULL, '15000', NULL, NULL, NULL, NULL, NULL, '15000', '15000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'DIPROSES', '', NULL, NULL, '1', NULL, NULL, NULL, '2023-12-20 09:30:17', 'administrator', '2023-12-20 09:30:17', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('63', '14', '33', '1', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00028', '28', '2023-12-20 18:41:58', '2023-12-22 17:00:00', '2023-12-20 18:41:58', NULL, '34000', NULL, NULL, NULL, NULL, NULL, '34000', '20000', '20000', NULL, 'PANJAR', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, '2', NULL, NULL, NULL, '2023-12-20 18:41:58', 'administrator', '2023-12-20 18:41:58', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('64', '14', '43', '1', NULL, '7', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00029', '29', '2023-12-22 22:57:53', '2023-12-24 17:00:00', '2023-12-22 22:57:53', NULL, '25000', NULL, NULL, NULL, NULL, NULL, '25000', '30000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'DIJEMPUT', '', NULL, NULL, '1', NULL, NULL, NULL, '2023-12-22 22:57:53', 'Rudi', '2023-12-22 22:57:53', 'Rudi', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('65', '14', '33', '1', NULL, '7', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00030', '30', '2023-12-22 22:58:48', '2023-12-24 17:00:00', '2023-12-22 22:58:48', NULL, '7000', NULL, NULL, NULL, NULL, NULL, '7000', '10000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'DIJEMPUT', '', NULL, NULL, '1', NULL, NULL, NULL, '2023-12-22 22:58:48', 'Rudi', '2023-12-22 22:58:48', 'Rudi', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('66', '14', '32', '1', NULL, '2', NULL, NULL, NULL, NULL, '5', 'BILLOT1-00031', '31', '2024-04-29 09:54:17', '2024-05-01 17:00:00', '2024-04-29 09:54:17', '2024-05-04 00:34:55', '25000', NULL, NULL, NULL, NULL, NULL, '25000', '50000', '0', NULL, 'CASH', 'Menunggu Driver', 'Selesai', 'BARU', '', NULL, NULL, '1', NULL, NULL, NULL, '2024-04-29 09:54:17', 'administrator', '2024-05-04 00:34:55', 'cashier001', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('67', '14', '35', '3', NULL, '2', NULL, NULL, NULL, NULL, '5', 'BILLOT1-00032', '32', '2024-05-03 23:00:44', '2024-05-05 17:00:00', '2024-05-03 23:00:44', '2024-05-04 00:33:15', '32000', NULL, NULL, NULL, NULL, NULL, '32000', '32000', '0', NULL, 'CASH', 'Menunggu Driver', 'Selesai', 'BARU', 'Tepat waktu', NULL, NULL, '2', NULL, NULL, NULL, '2024-05-03 23:00:44', 'administrator', '2024-05-04 00:33:15', 'cashier001', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('68', '14', '35', '1', '1', '2', NULL, NULL, NULL, NULL, '5', 'BILLOT1-00033', '33', '2024-05-04 19:33:42', '2024-05-06 17:00:00', '2024-05-04 19:33:42', '2024-05-05 04:06:56', '25000', NULL, NULL, NULL, NULL, NULL, '25000', '10000', '5000', '20000', 'PANJAR', 'Menunggu Driver', 'Selesai', 'BARU', '', NULL, NULL, '1', NULL, NULL, NULL, '2024-05-04 19:33:42', 'administrator', '2024-05-05 04:06:56', 'cashier001', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('69', '14', '35', '1', NULL, '2', '3', NULL, NULL, NULL, NULL, 'BILLOT1-00034', '34', '2024-05-04 19:35:14', '2024-05-06 17:00:00', '2024-05-04 19:35:14', NULL, '7000', NULL, NULL, NULL, NULL, NULL, '7000', '7000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, '1', NULL, NULL, NULL, '2024-05-04 19:35:14', 'administrator', '2024-06-02 01:01:37', 'cashier001', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('70', '14', '47', '1', '3', '5', NULL, NULL, NULL, NULL, '5', 'BILLOT1-00035', '35', '2024-05-06 22:49:28', '2024-05-08 17:00:00', '2024-05-06 22:49:28', '2024-05-06 22:52:59', '25000', NULL, NULL, NULL, NULL, NULL, '25000', '20000', '5000', '20000', 'PANJAR', 'Menunggu Driver', 'Selesai', 'DIPROSES', 'hati2 ', NULL, NULL, '1', NULL, NULL, NULL, '2024-05-06 22:49:28', 'cashier001', '2024-05-06 22:52:59', 'cashier001', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('71', '15', '38', '1', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT2-00006', '6', '2024-05-09 23:16:46', '2024-05-11 17:00:00', '2024-05-09 23:16:46', NULL, '10000', NULL, NULL, NULL, NULL, NULL, '10000', '50000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, '1', NULL, NULL, NULL, '2024-05-09 23:16:46', 'administrator', '2024-05-09 23:16:46', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('72', '14', '35', '1', NULL, '5', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00036', '36', '2024-05-10 01:54:30', '2024-05-12 17:00:00', '2024-05-10 01:54:30', NULL, '35000', NULL, NULL, NULL, NULL, NULL, '35000', '20000', '20000', NULL, 'PANJAR', 'Menunggu Driver', 'Baru', 'DIJEMPUT', 'Buat wangi ya', NULL, NULL, '1', NULL, NULL, NULL, '2024-05-10 01:54:30', 'cashier001', '2024-05-10 01:54:30', 'cashier001', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('73', '14', '33', '1', NULL, '2', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00037', '37', '2024-05-11 01:13:57', '2024-05-13 17:00:00', '2024-05-11 01:13:57', NULL, '9000', NULL, NULL, NULL, NULL, NULL, '9000', '100000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, '1', NULL, NULL, NULL, '2024-05-11 01:13:57', 'administrator', '2024-05-11 01:13:57', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('74', '14', '32', '1', NULL, '5', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00038', '38', '2024-05-14 09:56:04', '2024-05-16 17:00:00', '2024-05-14 09:56:04', NULL, '20000', NULL, NULL, NULL, NULL, NULL, '20000', '20000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, '1', NULL, NULL, NULL, '2024-05-14 09:56:04', 'cashier001', '2024-05-14 09:56:04', 'cashier001', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('75', '14', '32', '1', NULL, '2', NULL, NULL, NULL, NULL, '2', 'BILLOT1-00039', '39', '2024-05-31 06:39:49', '2024-06-02 17:00:00', '2024-05-31 06:39:49', '2024-06-03 01:08:32', '15000', NULL, NULL, NULL, NULL, NULL, '15000', '15000', '0', NULL, 'CASH', 'Menunggu Driver', 'Selesai', 'BARU', '', NULL, NULL, '1', NULL, NULL, NULL, '2024-05-31 06:39:49', 'administrator', '2024-06-03 01:08:32', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('76', '14', '35', '1', NULL, '5', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00040', '40', '2024-05-31 09:30:14', '2024-06-02 17:00:00', '2024-05-31 09:30:14', NULL, '30000', NULL, NULL, NULL, NULL, NULL, '30000', '50000', '20000', NULL, 'PANJAR', 'Menunggu Driver', 'Baru', 'DIJEMPUT', 'Bersih ya', NULL, NULL, '1', NULL, NULL, NULL, '2024-05-31 09:30:14', 'cashier001', '2024-05-31 09:30:14', 'cashier001', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('77', '14', '44', '1', NULL, '5', NULL, NULL, NULL, NULL, '2', 'BILLOT1-00041', '41', '2024-06-01 19:14:34', '2024-06-03 17:00:00', '2024-06-01 19:14:34', '2024-06-02 21:07:55', '59000', '10000', NULL, NULL, NULL, NULL, '49000', '100000', '0', NULL, 'CASH', 'Menunggu Driver', 'Selesai', 'DIPROSES', '', NULL, NULL, '2', NULL, NULL, NULL, '2024-06-01 19:14:34', 'cashier001', '2024-06-02 21:07:55', 'administrator', '1');
INSERT INTO `transaction_group` (`idtransaction_group`, `idoutlet`, `idcustomer`, `idpayment_type`, `idpayment_type_finish`, `iduser`, `iddriver`, `idproduction`, `iddriver_return`, `idcashier_return`, `idpickup`, `code`, `code_num`, `date`, `duedate`, `pay_date`, `pickup_date`, `grand_total`, `grand_discount`, `grand_discount_percent`, `grand_add_cost`, `grand_tax`, `grand_tax_percent`, `grand_total_final`, `total_pay`, `total_panjar`, `total_pay_finish`, `payment_status`, `process_status`, `transaction_group_status`, `dstb_status`, `note`, `hanger_no`, `rack`, `total_pcs`, `pending_description`, `stock_position`, `add_cost_note`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('78', '14', '44', '1', NULL, '5', NULL, NULL, NULL, NULL, NULL, 'BILLOT1-00042', '42', '2024-06-04 03:27:39', '2024-06-06 17:00:00', '2024-06-04 03:27:39', NULL, '17000', '1700', '10', NULL, NULL, NULL, '15300', '50000', '0', NULL, 'CASH', 'Menunggu Driver', 'Baru', 'BARU', '', NULL, NULL, '1', NULL, NULL, NULL, '2024-06-04 03:27:39', 'cashier001', '2024-06-04 03:27:39', 'cashier001', '1');


#
# TABLE STRUCTURE FOR: user
#

DROP TABLE IF EXISTS `user`;

CREATE TABLE `user` (
  `iduser` int(11) NOT NULL AUTO_INCREMENT,
  `idrole` int(11) DEFAULT NULL,
  `idoutlet` int(11) DEFAULT NULL,
  `username` varchar(200) DEFAULT NULL,
  `password` varchar(200) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL,
  `email` varchar(200) DEFAULT NULL,
  `address` varchar(300) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`iduser`),
  KEY `FK_user_role` (`idrole`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

INSERT INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', NULL, NULL, 'superadmin', '85bb6dec1873bb465770dde5e5264517', 'Superadmin', 'superadmin@superadmin.com', 'Indonesia', '2016-10-30 15:46:48', 'system', '2016-10-30 15:46:48', 'system', '1');
INSERT INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', '1', NULL, 'administrator', '5f4dcc3b5aa765d61d8327deb882cf99', 'administrator', 'admin@admin.com', 'Indonesia', '2017-04-24 23:17:59', 'superadmin', '2017-06-18 16:28:34', 'administrator', '1');
INSERT INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', '3', '14', 'driver001', '5f4dcc3b5aa765d61d8327deb882cf99', 'Sang Driver', '-', '-', '2021-04-18 11:29:32', 'superadmin', '2021-04-18 11:29:32', 'superadmin', '1');
INSERT INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('4', '4', NULL, 'production001', '202cb962ac59075b964b07152d234b70', 'Om Produksi', '-', '-', '2021-04-18 13:23:37', 'superadmin', '2024-05-04 09:22:34', 'administrator', '1');
INSERT INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('5', '2', '14', 'cashier001', '5f4dcc3b5aa765d61d8327deb882cf99', 'Mbak Kasir', '-', '-', '2021-04-18 14:01:06', 'superadmin', '2024-05-04 09:05:52', 'administrator', '1');
INSERT INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('6', '2', '15', 'Kasir', 'c7911af3adbd12a035b289556d96470a', 'Test', 'Hah@gmail.com', 'Jl saudara', '2021-06-18 04:16:25', 'administrator', '2024-05-08 20:40:06', 'administrator', '1');
INSERT INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('7', '2', '14', 'Rudi', '81dc9bdb52d04dc20036dbd8313ed055', 'RUDI', 'rudi@gmail.com', 'Jl suka', '2021-08-18 21:11:12', 'administrator', '2023-12-22 22:57:04', 'administrator', '1');
INSERT INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('8', '2', NULL, 'Tomi', '202cb962ac59075b964b07152d234b70', 'Tomi', 'Tomi@gmail.com', 'Jl suka', '2021-08-18 21:12:10', 'administrator', '2021-08-18 21:12:10', 'administrator', '1');
INSERT INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('9', '3', '14', 'Risky', '202cb962ac59075b964b07152d234b70', 'Risky', 'A@gmail.com', 'Tets', '2022-07-27 19:37:50', 'administrator', '2022-07-27 19:37:50', 'administrator', '1');
INSERT INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('10', '2', '14', 'Kasir', '202cb962ac59075b964b07152d234b70', 'Kasir', 'citrasd1902@gmail.com', 'Hwhwh', '2022-07-29 06:39:28', 'administrator', '2022-07-29 06:39:28', 'administrator', '1');
INSERT INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('11', '1', '14', 'Produksi', '202cb962ac59075b964b07152d234b70', 'Fahmi', 'Hsh@h.com', 'hshsj', '2022-07-30 13:48:13', 'administrator', '2022-07-30 13:49:42', 'administrator', '0');
INSERT INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('12', '4', '14', 'Produksi', '202cb962ac59075b964b07152d234b70', 'Dedek', 'H@j.com', 'Johor', '2022-07-30 13:50:49', 'administrator', '2022-07-30 13:50:49', 'administrator', '1');
INSERT INTO `user` (`iduser`, `idrole`, `idoutlet`, `username`, `password`, `name`, `email`, `address`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('13', '2', '16', 'cindy5567', '99c5e07b4d5de9d18c350cdf64c5aa3d', 'Cindy', 'ksask@gmail.com', 'jl', '2024-05-06 07:41:26', 'administrator', '2024-05-06 07:45:31', 'administrator', '1');


#
# TABLE STRUCTURE FOR: user_role
#

DROP TABLE IF EXISTS `user_role`;

CREATE TABLE `user_role` (
  `iduser_role` int(11) NOT NULL AUTO_INCREMENT,
  `idrole` int(11) DEFAULT NULL,
  `menu_name` varchar(200) DEFAULT NULL,
  `access` int(11) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `createdby` varchar(50) DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `updatedby` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT '1',
  PRIMARY KEY (`iduser_role`),
  KEY `FK_user_role_role` (`idrole`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=latin1;

INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('1', '3', 'dashboard', '1', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('2', '3', 'master', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('3', '3', 'outlet', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('4', '3', 'colour', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('5', '3', 'hue', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('6', '3', 'spot', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('7', '3', 'additional_cost', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('8', '3', 'payment_type', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('9', '3', 'customers', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('10', '3', 'customer_category', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('11', '3', 'customer', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('12', '3', 'items', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('13', '3', 'product', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('14', '3', 'item', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('15', '3', 'transaction', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('16', '3', 'pickup', '0', '2021-04-18 12:10:31', 'superadmin', '2021-04-18 13:53:30', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('17', '3', 'entry_photo', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('18', '3', 'st_process', '1', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('19', '3', 'st_clean', '1', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('20', '3', 'transactions', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('21', '3', 'outlays', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('22', '3', 'outlay_type', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('23', '3', 'outlay', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('24', '3', 'report', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('25', '3', 'profit_report', '0', '2021-04-18 12:10:31', 'superadmin', '2021-04-18 13:53:30', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('26', '3', 'user', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('27', '3', 'user_user', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('28', '3', 'user_user_role', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('29', '3', 'setting', '0', '2021-04-18 12:10:31', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('30', '4', 'dashboard', '1', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('31', '4', 'master', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('32', '4', 'outlet', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('33', '4', 'colour', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('34', '4', 'hue', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('35', '4', 'spot', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('36', '4', 'additional_cost', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('37', '4', 'payment_type', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('38', '4', 'customers', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('39', '4', 'customer_category', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('40', '4', 'customer', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('41', '4', 'items', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('42', '4', 'product', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('43', '4', 'item', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('44', '4', 'transaction', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('45', '4', 'pickup', '0', '2021-04-18 13:24:13', 'superadmin', NULL, NULL, '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('46', '4', 'entry_photo', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('47', '4', 'st_process', '1', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('48', '4', 'st_clean', '1', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('49', '4', 'transactions', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('50', '4', 'outlays', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('51', '4', 'outlay_type', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('52', '4', 'outlay', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('53', '4', 'report', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('54', '4', 'profit_report', '0', '2021-04-18 13:24:13', 'superadmin', NULL, NULL, '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('55', '4', 'user', '0', '2021-04-18 13:24:13', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('56', '4', 'user_user', '0', '2021-04-18 13:24:14', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('57', '4', 'user_user_role', '0', '2021-04-18 13:24:14', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('58', '4', 'setting', '0', '2021-04-18 13:24:14', 'superadmin', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('59', '2', 'dashboard', '1', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('60', '2', 'master', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('61', '2', 'outlet', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('62', '2', 'colour', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('63', '2', 'hue', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('64', '2', 'spot', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('65', '2', 'additional_cost', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('66', '2', 'payment_type', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('67', '2', 'customers', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('68', '2', 'customer_category', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('69', '2', 'customer', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('70', '2', 'items', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('71', '2', 'product', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('72', '2', 'item', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('73', '2', 'transaction', '1', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('74', '2', 'pickup', '1', '2021-04-18 13:53:44', 'superadmin', NULL, NULL, '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('75', '2', 'entry_photo', '1', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('76', '2', 'st_process', '1', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('77', '2', 'st_clean', '1', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('78', '2', 'transactions', '1', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('79', '2', 'outlays', '1', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('80', '2', 'outlay_type', '1', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('81', '2', 'outlay', '1', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('82', '2', 'report', '1', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('83', '2', 'profit_report', '0', '2021-04-18 13:53:44', 'superadmin', '2021-04-18 14:59:33', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('84', '2', 'user', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('85', '2', 'user_user', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('86', '2', 'user_user_role', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('87', '2', 'setting', '0', '2021-04-18 13:53:44', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('88', '2', 'pic_kup', '1', '2021-04-18 14:59:33', 'superadmin', NULL, NULL, '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('89', '1', 'dashboard', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('90', '1', 'master', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('91', '1', 'outlet', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('92', '1', 'colour', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('93', '1', 'hue', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('94', '1', 'spot', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('95', '1', 'additional_cost', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('96', '1', 'payment_type', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('97', '1', 'customers', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('98', '1', 'customer_category', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('99', '1', 'customer', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('100', '1', 'items', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('101', '1', 'product', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('102', '1', 'item', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('103', '1', 'transaction', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('104', '1', 'pick_up', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('105', '1', 'entry_photo', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('106', '1', 'st_process', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('107', '1', 'st_clean', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('108', '1', 'transactions', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('109', '1', 'outlays', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('110', '1', 'outlay_type', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('111', '1', 'outlay', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('112', '1', 'report', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('113', '1', 'dpt_report', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('114', '1', 'user', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('115', '1', 'user_user', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('116', '1', 'user_user_role', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('117', '1', 'setting', '1', '2021-04-18 21:09:35', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('118', '2', 'pick_up', '1', '2021-04-18 21:10:07', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('119', '2', 'dpt_report', '1', '2021-04-18 21:10:07', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('120', '1', 'dstb_process', '1', '2021-07-01 07:34:46', 'superadmin', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('121', '2', 'dstb_process', '1', '2021-07-01 07:34:59', 'superadmin', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('122', '3', 'pick_up', '0', '2021-07-04 00:51:57', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('123', '3', 'dstb_process', '1', '2021-07-04 00:51:57', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('124', '3', 'dpt_report', '0', '2021-07-04 00:51:57', 'superadmin', '2024-05-30 09:59:24', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('125', '1', 'cash_report', '1', '2023-02-21 01:42:02', 'administrator', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('126', '2', 'cash_report', '1', '2024-05-04 08:38:04', 'administrator', '2024-05-30 09:59:15', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('127', '4', 'pick_up', '0', '2024-05-04 09:38:29', 'administrator', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('128', '4', 'dstb_process', '1', '2024-05-04 09:38:29', 'administrator', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('129', '4', 'dpt_report', '0', '2024-05-04 09:38:29', 'administrator', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('130', '4', 'cash_report', '0', '2024-05-04 09:38:29', 'administrator', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('131', '1', 'history_bill_production', '1', '2024-05-14 22:59:57', 'administrator', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('132', '1', 'dstb_clean', '1', '2024-05-30 09:59:08', 'administrator', '2024-06-04 03:06:57', 'superadmin', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('133', '2', 'history_bill_production', '0', '2024-05-30 09:59:15', 'administrator', NULL, NULL, '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('134', '2', 'dstb_clean', '1', '2024-05-30 09:59:15', 'administrator', NULL, NULL, '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('135', '3', 'history_bill_production', '0', '2024-05-30 09:59:24', 'administrator', NULL, NULL, '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('136', '3', 'dstb_clean', '1', '2024-05-30 09:59:24', 'administrator', NULL, NULL, '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('137', '3', 'cash_report', '0', '2024-05-30 09:59:24', 'administrator', NULL, NULL, '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('138', '4', 'history_bill_production', '1', '2024-05-30 09:59:32', 'administrator', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('139', '4', 'dstb_clean', '1', '2024-05-30 09:59:32', 'administrator', '2024-05-31 06:38:01', 'administrator', '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('140', '1', 'role_delete_transaction', '1', '2024-06-04 03:06:57', 'superadmin', NULL, NULL, '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('141', '1', 'role_delete_dstb_process', '1', '2024-06-04 03:06:57', 'superadmin', NULL, NULL, '1');
INSERT INTO `user_role` (`iduser_role`, `idrole`, `menu_name`, `access`, `created`, `createdby`, `updated`, `updatedby`, `status`) VALUES ('142', '1', 'role_delete_dstb_clean', '1', '2024-06-04 03:06:57', 'superadmin', NULL, NULL, '1');


SET foreign_key_checks = 1;
