<script>

	function filter_data() {
		var table = jQuery('#pick_up').dataTable({bRetrieve: true});
		table.fnDraw(false);
	}

	jQuery('body').on('change', '#idcustomer', function() {
		filter_data();
	});

	jQuery('body').on('click', '.btn-go-data', function(){ 
		var code = jQuery('#inp_code').val();
		get_detail(code);
	});

	function get_detail(code) {
		show_loading();
		jQuery.ajax({
			url: app_url + 'pick_up/get_detail',
			type: 'POST',
			dataType: 'JSON',
			data: {
				code: code
			},
			success: function(response) {
				hide_loading();
				if (response.err_code == 0) {
					show_modal('detail');
					jQuery('.container-detail').html(response.data);

					if (response.is_hide_btn) {
						jQuery('.az-modal-detail').find('.modal-footer').addClass('hide');
					}
					else {
						jQuery('.az-modal-detail').find('.modal-footer').removeClass('hide');
					}

					calculate_pay();
				}
				else {
					bootbox.alert(response.err_message);
				}
			},
			error: function(resp) {}
		});
	}

	jQuery('body').on('click', '.btn-detail', function() {
		var code = jQuery(this).attr('data-code');
		get_detail(code);
	});

	jQuery('body').on('keyup keydown', '#total_pay', function() {
		calculate_pay();
	});

	jQuery('body').on('click', '.money-list', function() {
		var val = jQuery(this).attr('data-id');
        jQuery('#total_pay').val(thousand_separator_decimal(val));

        calculate_pay();
	});

	function calculate_pay() {
		var info_total_final = jQuery('#grand_total_final').val() || 0;
		info_total_final = remove_separator(info_total_final);
		var pay = jQuery('#total_panjar').val() || 0;
		pay = remove_separator(pay);
		var not_yet = parseFloat(info_total_final) - parseFloat(pay);

		var lack = not_yet;
        if (not_yet < 0) {
            lack = 0;
        }

        var pay_type = jQuery('#pay_type').val();
        if (pay_type == 'BELUM BAYAR') {
        	not_yet = info_total_final;
        }

        if (pay_type == 'PANJAR') {
        	jQuery('.container-panjar').show();
        }
        else {
        	jQuery('.container-panjar').hide();
        }

        if (pay_type == 'CASH') {
        	jQuery('#form_pay').hide();
        }

        var idpayment = jQuery('#idpayment_type_finish').val();
    	if (idpayment == '1') {
    		jQuery('.container-pay-tunai').show();
    	}
    	else {
    		jQuery('.container-pay-tunai').hide();
    	}

        var ret_money = 0;
        var total_cash = jQuery('#total_pay').val() || 0;
        total_cash = remove_separator(total_cash);


        var calc_ret = total_cash - not_yet;
        if (calc_ret > 0) {
            ret_money = calc_ret;
        }

        jQuery('#p_info_ret_money').val(thousand_separator_decimal(ret_money));
        jQuery('#p_info_lack').val(thousand_separator_decimal(not_yet));
	}

	jQuery('body').on('change', '#idpayment_type_finish', function() {
		calculate_pay();
	});

	jQuery('body').on('click', '.btn-action-pickup', function(){
		show_loading();
		jQuery.ajax({
			url: app_url + 'pick_up/process',
			type: 'POST',
			dataType: 'JSON',
			data: jQuery('#form_pay').serialize(),
			success: function(response) {
				hide_loading();
				if (response.err_code == 0) {
					bootbox.alert({
						message: 'Pick Up Berhasil',
						callback: function(res) {
							location.reload();
						}
					});
				}
				else {
					bootbox.alert(response.err_message);
				}
			},
			error: function(resp) {}
		});
	});