<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class St_clean extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('st_clean');

        $this->table = 'st_clean';
        $this->load->helper('az_crud');
        $this->load->library('AZApp');
        $this->crud = $this->azapp->add_crud();
    }

	public function index(){
		$azapp = $this->azapp;
		
		$data_header['title'] = 'ST Bersih';
		$data_header['breadcrumb'] = array('st_clean');
		$azapp->set_data_header($data_header);

		$view = $this->load->view('st_process/v_st_process', '', true);
		$azapp->add_content($view);

		$this->load->helper('az_core');

		$azapp->add_content("<div class='container-scanner hide'><button class='btn btn-danger btn-sm btn-close-scanner' type='button'>".azlang('Close')."</button><br><video class='scanner' id='scanner'></video></div>");

		$param['type'] = 'st_clean';
		$js = az_add_js('js/vjs_act_scanner', $param);
		$azapp->add_js($js);

		$js = az_add_js('st_clean/vjs_st_clean');
		$azapp->add_js($js);
		
		echo $azapp->render();	
	}

	function get_data() {
		$code = $this->input->post('code');
		$err_code = 0;
		$err_message = '';
		$view = '';
		$idrole = $this->session->userdata('idrole');

		if (strlen($code) == 0) {
			$err_code++;
			$err_message = 'Harap isi Kode Bill';
		}

		if ($err_code == 0) {
			$this->db->where('code', $code);
			$this->db->where_in('process_status', array('Produksi', 'Pengantaran', 'Selesai'));
			$check = $this->db->get('transaction_group');

			if ($check->num_rows() == 0) {
				$err_code++;
				$err_message = 'Data tidak ditemukan';
			}
		}

		if ($err_code == 0) {
			if ($idrole == 3) {
				$this->db->where('code', $code);
				$this->db->where('iddriver_return', $this->session->userdata('iduser'));
				$check = $this->db->get('transaction_group');

				if ($check->num_rows() == 0) {
					$err_code++;
					$err_message = 'Data tidak ditemukan';
				}
			}
		}

		if ($err_code == 0) {
			$this->load->library('Laundry');
			$rdata = $this->laundry->invoice($code);

			$err_code = azarr($rdata, 'err_code');
			$err_message = azarr($rdata, 'err_message');
		}

		if ($err_code == 0) {
			$rdata['html'] = false;
			$this->db->where('status', 1);
			$this->db->where('idrole', 3);
			$rdata['driver'] = $this->db->get('user');

			$view = $this->load->view('sales_transaction/v_invoice_production', $rdata, true);
			$view .= $this->load->view('st_clean/v_tmp_st_clean', $rdata, true);
		}


		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message,
			'data' => $view
		);
		echo json_encode($return);
	}

	function save() {
		$err_code = 0;
		$err_message = '';
		$id = $this->input->post('id');
		$iddriver_return = $this->input->post('iddriver_return');

		if (strlen($iddriver_return) == 0) {
			$err_code++;
			$err_message = 'Harap pilih driver';
		}

		if ($err_code == 0) {
			$arr['iddriver_return'] = $iddriver_return;
			az_crud_save($id, 'transaction_group', $arr);
		}

		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message
		);
		echo json_encode($return);
	}

	function approve_bill() {
		$err_code = 0;
		$err_message = '';
		$id = $this->input->post('id');
		
		$idrole = $this->session->userdata('idrole');

		if (strlen($id) == 0) {
			$err_code++;
			$err_message = 'ID not valid';
		}

		if ($idrole != '3') {
			$err_code++;
			$err_message = 'Akses ditolak';
		}

		if ($err_code == 0) {
			$arr = array(
				'process_status' => 'Pengantaran',
			);
			az_crud_save($id, 'transaction_group', $arr);
		}

		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message
		);
		echo json_encode($return);
	}

	function receive() {
		$err_code = 0;
		$err_message = '';
		$id = $this->input->post('id');
		
		$idrole = $this->session->userdata('idrole');

		if (strlen($id) == 0) {
			$err_code++;
			$err_message = 'ID not valid';
		}

		if ($idrole != '2') {
			$err_code++;
			$err_message = 'Akses ditolak';
		}

		if ($err_code == 0) {
			$arr = array(
				'transaction_group_status' => 'Pick Up',
				'hanger_no' => $this->input->post('hanger_no'),
				'rack' => $this->input->post('rack'),
				'process_status' => 'Selesai',
				'idcashier_return' => $this->session->userdata('iduser')
			);
			az_crud_save($id, 'transaction_group', $arr);
		}

		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message
		);
		echo json_encode($return);
	}
}