<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payment_type extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('payment_type');

        $this->table = 'payment_type';
        $this->load->helper('az_crud');
        $this->load->library('AZApp');
        $this->crud = $this->azapp->add_crud();
    }

	public function index(){
		$azapp = $this->azapp;
		$crud = $this->crud;
		$this->load->helper('az_role');

		$crud->set_column(array(azlang('No'), 'Nama Pembayaran', azlang('Action')));
		$crud->set_id($this->table);
		$crud->set_default_url(true);

		$v_modal = $this->load->view('payment_type/v_payment_type', '', true);
		$crud->set_form('form');
		$crud->set_modal($v_modal);
		$crud->set_modal_title('Jenis Pembayaran');
		$v_modal = $crud->generate_modal();
		
		$crud = $crud->render();
		$crud .= $v_modal;	
		$azapp->add_content($crud);

		$data_header['title'] = 'Jenis Pembayaran';
		$data_header['breadcrumb'] = array('master', 'payment_type');
		$azapp->set_data_header($data_header);
		
		echo $azapp->render();	
	}

	public function get() {
		$crud = $this->crud;
		$crud->set_select('idpayment_type, payment_type_name');
		$crud->set_filter('payment_type_name');
		$crud->set_sorting('payment_type_name');
		$crud->set_id($this->table);
		$crud->add_where("status > 0");
		$crud->set_table($this->table);
		$crud->set_custom_style('custom_style');

		echo $crud->get_table();
	}

	function custom_style($key, $value, $data) {
		if ($key == 'action') {
			$id = azarr($data, 'idpayment_type');
			if ($id == 1) {
				$btn = '<button class="btn btn-default btn-xs btn-edit-payment_type" data_id="'.$id.'"><span class="glyphicon glyphicon-pencil"></span> Edit</button>';
				return $btn;
			}
		}
		return $value;
	}

	public function save(){
		$data = array();
		$data_post = $this->input->post();
		$idpost = azarr($data_post, 'id'.$this->table);
		$data["sMessage"] = "";
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('', '');

		$this->form_validation->set_rules('payment_type_name', 'Nama Pembayaran', 'required|trim|max_length[200]');

		$err_code = 0;
		$err_message = "";

		if($this->form_validation->run() == TRUE){
			$data_save = array(
				"payment_type_name" => azarr($data_post, 'payment_type_name'),
			);

			$response_save = az_crud_save($idpost, $this->table, $data_save);
			$err_code = azarr($response_save, 'err_code');
			$err_message = azarr($response_save, 'err_message');
		}

		$data["sMessage"] = validation_errors().$err_message;
		echo json_encode($data);
	}

	public function edit() {
		az_crud_edit('idpayment_type, payment_type_name');
	}

	public function delete() {
		$id = $this->input->post("id");
		az_crud_delete('payment_type', $id);
	}
}