<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Item extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('item');
        $this->table = 'item';
        $this->controller = 'item';
        $this->load->helper('az_crud');
    }

	public function index(){
		$this->load->library('AZApp');
		$azapp = $this->azapp;
		$crud = $azapp->add_crud();

		$crud->set_column(array('#', azlang('Outlet'), azlang('Code'), 'Jenis Barang', 'Nama Pelanggan', 'Gambar', azlang('Action')));
		$crud->set_id($this->controller);
		$crud->set_default_url(true);

		$this->db->where('status', 1);
		$data['outlet'] = $this->db->get('outlet');

		if (strlen($this->session->userdata('idoutlet')) == 0) {
			// $v_filter = $this->load->view('item/v_filter_item', '', true);
			// $crud->set_top_filter($v_filter);			
		}

		$txt_callback = '';
		for ($i=1; $i <= 6; $i++) { 
			$file = $azapp->add_file();
	        $file->set_page_id($this->controller);
	        $file->set_file_size('500 KB');
	        $file->set_id('photo'.$i);
	        $file->set_file_dir('item');
	        $file->set_path(base_url().AZAPP.'assets/');
	        $data['photo'.$i] = $file->render();			
	        $txt_callback .= "callback_photo".$i."(response);";
		}

		$txt_callback .= "generate_edit(response);";

		$crud->set_callback_edit($txt_callback);
		$crud->set_callback_add("
			jQuery('#idhue').val([]).change();
			jQuery('#idcolour').val([]).change();
		");

		$this->db->where('status', 1);
		$data['hue'] = $this->db->get('hue');

		$this->db->where('status', 1);
		$data['colour'] = $this->db->get('colour');

		$v_modal = $this->load->view('item/v_item', $data, true);
		$crud->set_form('form');
		$crud->set_modal($v_modal);
		$crud->set_modal_title('Data Barang');
		$v_modal = $crud->generate_modal();

		$this->load->helper('az_core');
		$js = az_add_js('item/vjs_item');
		$azapp->add_js($js);
		
		$crud = $crud->render();
		$crud .= $v_modal;	
		$azapp->add_content($crud);

		$data_header['title'] = 'Data Barang';
		$data_header['breadcrumb'] = array('items', 'item');
		$azapp->set_data_header($data_header);
		
		echo $azapp->render();	
	}

	public function get() {
		$this->load->library('AZApp');
		$crud = $this->azapp->add_crud();
		$crud->set_select('iditem, outlet_name, item_code, product_name, customer_name, idhue, idcolour, "" as the_hue, "" as the_colour, "" as photo, photo1, photo2, photo3, photo4, photo5, photo6');
		$crud->set_select_table('iditem, outlet_name, item_code, product_name, customer_name, photo');
		$crud->set_filter('outlet_name, item_code, product_name, customer_name');
		$crud->set_sorting('outlet_name, item_code, product_name, customer_name');
		$idoutlet = $this->session->userdata('idoutlet');
		if (strlen($idoutlet) > 0) {
			$crud->add_where("product.idoutlet = ".$idoutlet);
		}
		$crud->add_join('product');
		$crud->add_join('customer');
		$crud->set_id($this->controller);
		$crud->add_where("item.status > 0");
		$crud->set_table($this->table);
		$crud->set_order_by('item_code');
		$crud->add_join_manual('outlet', 'product.idoutlet = outlet.idoutlet');
		$crud->set_custom_style('custom_style');
		echo $crud->get_table();
	}

	function custom_style($key, $value, $data) {
		if ($key == 'item_type') {
			return azlang($value);
		}
		else if ($key == 'the_colour') {

		}
		else if ($key == 'photo') {
			$photo1 = azarr($data, 'photo1');
			$photo2 = azarr($data, 'photo2');
			$photo3 = azarr($data, 'photo3');
			$photo4 = azarr($data, 'photo4');
			$photo5 = azarr($data, 'photo5');
			$photo6 = azarr($data, 'photo6');

			$img = '';

			if (strlen($photo1) > 0) {
				$img .= "<img class='img-item-list' src='".base_url().AZAPP.'assets/item/'.$photo1."'>";
			}
			if (strlen($photo2) > 0) {
				$img .= "<img class='img-item-list' src='".base_url().AZAPP.'assets/item/'.$photo2."'>";
			}
			if (strlen($photo3) > 0) {
				$img .= "<img class='img-item-list' src='".base_url().AZAPP.'assets/item/'.$photo3."'>";
			}
			if (strlen($photo4) > 0) {
				$img .= "<img class='img-item-list' src='".base_url().AZAPP.'assets/item/'.$photo4."'>";
			}
			if (strlen($photo5) > 0) {
				$img .= "<img class='img-item-list' src='".base_url().AZAPP.'assets/item/'.$photo5."'>";
			}
			if (strlen($photo6) > 0) {
				$img .= "<img class='img-item-list' src='".base_url().AZAPP.'assets/item/'.$photo6."'>";
			}

			return $img;
		}
		else if ($key == 'action') {
			$code = azarr($data, 'item_code');
			$btn = "<a href='".app_url().'item/qr_code/'.$code."' target='_blank'><button class='btn btn-default btn-xs' type='buttotn'><i class='fa fa-qrcode'></i> Cetak QR Code</button></a>";
			return $btn.$value;
		}
		return $value;
	}

	public function save(){
		$data = array();
		$data_post = $this->input->post();
		$idpost = azarr($data_post, 'id'.$this->table);
		$data['sMessage'] = '';
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('', '');

		$idoutlet = $this->input->post('idoutlet');
		$sess_idoutlet = $this->session->userdata('idoutlet');
		if (strlen($sess_idoutlet) == 0) {
			$this->form_validation->set_rules('idoutlet', azlang('Outlet'), 'required|trim|max_length[200]');
		}
		else {
			$idoutlet = $sess_idoutlet;
		}

		$this->form_validation->set_rules('idproduct', 'Jenis Barang', 'required|trim|max_length[200]');
		$this->form_validation->set_rules('idcustomer', 'Pelanggan', 'required|trim|max_length[200]');
		$this->form_validation->set_rules('idcolour[]', 'Warna', 'required|trim|max_length[200]');
		$this->form_validation->set_rules('idhue[]', 'Corak', 'required|trim|max_length[200]');

		$err_code = 0;
		$err_message = '';

		if($this->form_validation->run() == FALSE){
			$err_code++;
			$err_message = validation_errors();
		}

		if ($err_code == 0) {
			$this->db->trans_begin();

			$idcolour = implode(',', $this->input->post('idcolour'));
			$idhue = implode(',', $this->input->post('idhue'));

			$data_save = array(
				'idproduct' => $this->input->post('idproduct'),
				'idcustomer' => $this->input->post('idcustomer'),
				'idcolour' => $idcolour,
				'idhue' => $idhue,
			);

			if (strlen($idpost) == 0) {
				$data_code = az_generate_item_code($idoutlet);

				$code = azarr($data_code, 'item_code');
				$code_number = azarr($data_code, 'item_code_num');
				$data_save['item_code'] = $code;
				$data_save['item_code_num'] = $code_number;	
			}

			$response_save = az_crud_save($idpost, $this->table, $data_save);
			$err_code = azarr($response_save, 'err_code');
			$err_message = azarr($response_save, 'err_message');
			$insert_id = azarr($response_save, 'insert_id');

		}

		if ($err_code == 0) {
			$this->load->library('AZFile');
			$azfile = $this->azfile;
			$azfile->set_id('photo1');
			$azfile->set_file_dir('item');
			$azfile->set_max_size('500');
			$save_file = $azfile->save($insert_id, 'iditem', 'item', $idpost, APPPATH.'assets/item');
			$err_code = azarr($save_file, 'err_code');
			$err_message = azarr($save_file, 'err_message');
		}

		if ($err_code == 0) {
			$this->load->library('AZFile');
			$azfile = $this->azfile;
			$azfile->set_id('photo2');
			$azfile->set_file_dir('item');
			$azfile->set_max_size('500');
			$save_file = $azfile->save($insert_id, 'iditem', 'item', $idpost, APPPATH.'assets/item');
			$err_code = azarr($save_file, 'err_code');
			$err_message = azarr($save_file, 'err_message');
		}

		if ($err_code == 0) {
			$this->load->library('AZFile');
			$azfile = $this->azfile;
			$azfile->set_id('photo3');
			$azfile->set_file_dir('item');
			$azfile->set_max_size('500');
			$save_file = $azfile->save($insert_id, 'iditem', 'item', $idpost, APPPATH.'assets/item');
			$err_code = azarr($save_file, 'err_code');
			$err_message = azarr($save_file, 'err_message');
		}

		if ($err_code == 0) {
			$this->load->library('AZFile');
			$azfile = $this->azfile;
			$azfile->set_id('photo4');
			$azfile->set_file_dir('item');
			$azfile->set_max_size('500');
			$save_file = $azfile->save($insert_id, 'iditem', 'item', $idpost, APPPATH.'assets/item');
			$err_code = azarr($save_file, 'err_code');
			$err_message = azarr($save_file, 'err_message');
		}

		if ($err_code == 0) {
			$this->load->library('AZFile');
			$azfile = $this->azfile;
			$azfile->set_id('photo5');
			$azfile->set_file_dir('item');
			$azfile->set_max_size('500');
			$save_file = $azfile->save($insert_id, 'iditem', 'item', $idpost, APPPATH.'assets/item');
			$err_code = azarr($save_file, 'err_code');
			$err_message = azarr($save_file, 'err_message');
		}

		if ($err_code == 0) {
			$this->load->library('AZFile');
			$azfile = $this->azfile;
			$azfile->set_id('photo6');
			$azfile->set_file_dir('item');
			$azfile->set_max_size('500');
			$save_file = $azfile->save($insert_id, 'iditem', 'item', $idpost, APPPATH.'assets/item');
			$err_code = azarr($save_file, 'err_code');
			$err_message = azarr($save_file, 'err_message');
		}

		if ($this->db->trans_status() === FALSE || $err_code > 0) {
		    $this->db->trans_rollback();
		}
		else {
		    $this->db->trans_commit();
		}

		$data["sMessage"] = $err_message;
		echo json_encode($data);
	}

	public function edit() {
		$this->db->join('product', 'item.idproduct = product.idproduct');
		$this->db->join('hue', 'item.idhue = hue.idhue');
		$this->db->join('colour', 'item.idcolour = colour.idcolour');
		$this->db->join('outlet', 'outlet.idoutlet = product.idoutlet');
		$this->db->join('customer', 'item.idcustomer = customer.idcustomer');
		az_crud_edit('iditem,outlet_name as ajax_idoutlet, product.idoutlet, item_code, product_name as ajax_idproduct, item.idcustomer, customer_name as ajax_idcustomer, item.idproduct, item.idcolour, item.idhue, photo1, photo2, photo3, photo4, photo5, photo6');
	}

	public function delete() {
		$id = $this->input->post('id');
		az_crud_delete($this->table, $id);
	}

	function qr_code($code) {
		$param['code'] = $code;
		$this->load->view('item/v_qr_code', $param);
	}
}