<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Hue extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('hue');

        $this->table = 'hue';
        $this->load->helper('az_crud');
        $this->load->library('AZApp');
        $this->crud = $this->azapp->add_crud();
    }

	public function index(){
		$azapp = $this->azapp;
		$crud = $this->crud;
		$this->load->helper('az_role');

		$crud->set_column(array(azlang('No'), 'Nama Corak', azlang('Action')));
		$crud->set_id($this->table);
		$crud->set_default_url(true);

		$v_modal = $this->load->view('hue/v_hue', '', true);
		$crud->set_form('form');
		$crud->set_modal($v_modal);
		$crud->set_modal_title(azlang("Corak"));
		$v_modal = $crud->generate_modal();
		
		$crud = $crud->render();
		$crud .= $v_modal;	
		$azapp->add_content($crud);

		$data_header['title'] = azlang('Corak');
		$data_header['breadcrumb'] = array('master', 'hue');
		$azapp->set_data_header($data_header);
		
		echo $azapp->render();	
	}

	public function get() {
		$crud = $this->crud;
		$crud->set_select('idhue, hue_name');
		$crud->set_filter('hue_name');
		$crud->set_sorting('hue_name');
		$crud->set_id($this->table);
		$crud->add_where("status > 0");
		$crud->set_table($this->table);

		echo $crud->get_table();
	}

	public function save(){
		$data = array();
		$data_post = $this->input->post();
		$idpost = azarr($data_post, 'id'.$this->table);
		$data["sMessage"] = "";
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('', '');

		$this->form_validation->set_rules('hue_name', 'Nama Corak', 'required|trim|max_length[200]');

		$err_code = 0;
		$err_message = "";

		if($this->form_validation->run() == TRUE){
			$data_save = array(
				"hue_name" => azarr($data_post, 'hue_name'),
			);

			$response_save = az_crud_save($idpost, $this->table, $data_save);
			$err_code = azarr($response_save, 'err_code');
			$err_message = azarr($response_save, 'err_message');
		}

		$data["sMessage"] = validation_errors().$err_message;
		echo json_encode($data);
	}

	public function edit() {
		az_crud_edit('idhue, hue_name');
	}

	public function delete() {
		$id = $this->input->post("id");
		az_crud_delete('hue', $id);
	}
}