<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customer_category extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('customer_category');

        $this->table = 'customer_category';
        $this->load->helper('az_crud');
        $this->load->library('AZApp');
        $this->crud = $this->azapp->add_crud();
    }

	public function index(){
		$azapp = $this->azapp;
		$crud = $this->crud;
		$this->load->helper('az_role');

		$crud->set_column(array(azlang('No'), 'Nama Kategori Pelanggan', 'Jumlah Diskon (%)', azlang('Action')));
		$crud->set_id($this->table);
		$crud->set_default_url(true);

		$v_modal = $this->load->view('customer_category/v_customer_category', '', true);
		$crud->set_form('form');
		$crud->set_modal($v_modal);
		$crud->set_modal_title(azlang("Kategori Pelanggan"));
		$v_modal = $crud->generate_modal();
		
		$crud = $crud->render();
		$crud .= $v_modal;	
		$azapp->add_content($crud);

		$data_header['title'] = azlang('Kategori Pelanggan');
		$data_header['breadcrumb'] = array('customers', 'customer_category');
		$azapp->set_data_header($data_header);
		
		echo $azapp->render();	
	}

	public function get() {
		$crud = $this->crud;
		$crud->set_select('idcustomer_category, customer_category_name, discount_amount');
		$crud->set_filter('customer_category_name, discount_amount');
		$crud->set_sorting('customer_category_name, discount_amount');
		$crud->set_id($this->table);
		$crud->add_where("status > 0");
		$crud->set_table($this->table);
		$crud->set_custom_style('custom_style');

		echo $crud->get_table();
	}

	function custom_style($key, $value, $data) {
		if ($key == 'action') {
			$id = azarr($data, 'idcustomer_category');
			if ($id == 11) {
				$btn = '<button class="btn btn-default btn-xs btn-edit-customer_category" data_id="'.$id.'"><span class="glyphicon glyphicon-pencil"></span> Edit</button>';
				return $btn;
			}
		}
		return $value;
	}

	public function save(){
		$data = array();
		$data_post = $this->input->post();
		$idpost = azarr($data_post, 'id'.$this->table);
		$data["sMessage"] = "";
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('', '');

		$this->form_validation->set_rules('customer_category_name', 'Nama Kategori Pelanggan', 'required|trim|max_length[200]');
		$this->form_validation->set_rules('discount_amount', 'Jumlah Diskon', 'required|trim|max_length[200]');

		$err_code = 0;
		$err_message = "";

		if($this->form_validation->run() == TRUE){
			$data_save = array(
				"customer_category_name" => azarr($data_post, 'customer_category_name'),
				'discount_amount' => $this->input->post('discount_amount')
			);

			$response_save = az_crud_save($idpost, $this->table, $data_save);
			$err_code = azarr($response_save, 'err_code');
			$err_message = azarr($response_save, 'err_message');
		}

		$data["sMessage"] = validation_errors().$err_message;
		echo json_encode($data);
	}

	public function edit() {
		az_crud_edit('idcustomer_category, customer_category_name, discount_amount');
	}

	public function delete() {
		$id = $this->input->post("id");
		az_crud_delete('customer_category', $id);
	}
}