<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Laundry {
	function get_product() {
		$ci =& get_instance();

		$ci->load->library('AZApp');
		$azapp = $ci->azapp;

		$crud = $azapp->add_crud();
		$crud->set_column(array(azlang('No'), azlang('Product Code'), 'Jenis Produk', azlang('Sell Price'), 'Gambar', 'Warna', 'Corak', azlang('Action')));
		$crud->set_id("product");
		$crud->set_url("app_url+'data/get_data_product'");
		$crud->set_url_edit("app_url+'data/edit_data_product'");
		$crud->set_url_save("app_url+'data/save_data_product'");
		$crud->set_url_delete("app_url+'data/delete_data_product'");

		$crud->add_aodata('idoutlet', 'idoutlet');
		$crud->add_aodata('idcustomer', 'idcustomer');
		$crud->add_aodata('idtable', 'hd_idtable');
		$crud->set_btn_add(false);

		$crud = $crud->render();

		return $crud;
	}

	function invoice($code, $param_id = '') {
		$ci =& get_instance();
		$err_code = 0;
		$err_message = "";
		$arr_data = array();
		$data_transaction = array();
		$data_transaction_detail = array();
		$trx = array();

		$idoutlet = $ci->session->userdata('idoutlet');

		$ci->db->select('*, transaction_group.idoutlet, customer.address as customer_address, customer.phone as customer_phone, user.name as cashier_name, driver.name as driver_name, driver_return.name as driver_return_name');
		$ci->db->join('user', 'transaction_group.iduser = user.iduser');
		if (strlen($idoutlet) > 0) {
			$ci->db->where('transaction_group.idoutlet', $idoutlet);
		}

		if (strlen($param_id) > 0) {
			$ci->db->where('idtransaction_group', $param_id);
		}
		else {
			$ci->db->where('code', $code);
		}
		$ci->db->join('customer', 'transaction_group.idcustomer = customer.idcustomer', 'left');
		$ci->db->where('transaction_group.status', 1);
		$ci->db->join('user as driver', 'transaction_group.iddriver = driver.iduser', 'left');
		$ci->db->join('user as driver_return', 'transaction_group.iddriver_return = driver_return.iduser', 'left');
		$data = $ci->db->get('transaction_group');


		if ($data->num_rows() == 0) {
			$err_code++;
			$err_message = 'Data tidak ditemukan';
		}

		if ($err_code == 0) {
			$ci->db->where('idtransaction_group', $data->row()->idtransaction_group);
			$ci->db->where('transaction.status', 1);
			$ci->db->join('item', 'transaction.iditem = item.iditem');
			$ci->db->join('product', 'item.idproduct = product.idproduct');
			$transaction = $ci->db->get('transaction');

			$ci->db->where('idtransaction_group', $data->row()->idtransaction_group);
			$ci->db->where('transaction_detail.status', 1);
			$transaction_detail = $ci->db->get('transaction_detail');

			foreach ($transaction->result() as $key => $value) {
				$ci->db->where('idtransaction', $value->idtransaction);
				$ci->db->where('transaction_additional_cost.status', 1);
				$ci->db->join('additional_cost', 'transaction_additional_cost.idadditional_cost = additional_cost.idadditional_cost');
				$trx_cost = $ci->db->get('transaction_additional_cost');

				$arr_cost = array();
				foreach ($trx_cost->result() as $cost_key => $cost_value) {
					$arr_cost[] = array(
						'name' => $cost_value->cost_name,
						'price' => $cost_value->additional_price
					);
				}

				$photo1 = $value->photo1;
				$photo2 = $value->photo2;
				$photo3 = $value->photo3;
				$photo4 = $value->photo4;
				$photo5 = $value->photo5;
				$photo6 = $value->photo6;

				$img = '';

				if (strlen($photo1) > 0) {
					$img .= "<img class='img-item-list' src='".base_url().AZAPP.'assets/item/'.$photo1."'>";
				}
				if (strlen($photo2) > 0) {
					$img .= "<img class='img-item-list' src='".base_url().AZAPP.'assets/item/'.$photo2."'>";
				}
				if (strlen($photo3) > 0) {
					$img .= "<img class='img-item-list' src='".base_url().AZAPP.'assets/item/'.$photo3."'>";
				}
				if (strlen($photo4) > 0) {
					$img .= "<img class='img-item-list' src='".base_url().AZAPP.'assets/item/'.$photo4."'>";
				}
				if (strlen($photo5) > 0) {
					$img .= "<img class='img-item-list' src='".base_url().AZAPP.'assets/item/'.$photo5."'>";
				}
				if (strlen($photo6) > 0) {
					$img .= "<img class='img-item-list' src='".base_url().AZAPP.'assets/item/'.$photo6."'>";
				}

				$hue = az_convert_hue($value->idhue);
				$spot = az_convert_spot($value->idspot);
				$colour = az_convert_colour($value->idcolour);

				$trx[] = array(
					'hue' => $hue,
					'spot' => $spot,
					'colour' => $colour,
					'item_code' => $value->item_code,
					'product_name' => $value->product_name,
					'price' => $value->price,
					'add_cost' => $value->add_cost,
					'total' => $value->total,
					'img' => $img,
					'trx_note' => $value->trx_note,
					'arr_cost' => $arr_cost,
					'point_a' => $value->point_a,
					'point_b' => $value->point_b,
					'point_c' => $value->point_c,
					'point_d' => $value->point_d,
				);
			}


			$arr_data = azarr($data->result_array(), 0);
			$data_transaction = $transaction->result_array();
			$data_transaction_detail = $transaction_detail->result_array();
		}

		$data_outlet = array();
		if ($err_code == 0) {
			$ci->db->where('idoutlet', $data->row()->idoutlet);
			$data_outlet = $ci->db->get('outlet')->result_array();
			$data_outlet = azarr($data_outlet, 0);
		}

		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message,
			'data' => $arr_data,
			'transaction' => $data_transaction,
			'transaction_detail' => $data_transaction_detail,
			'outlet' => $data_outlet,
			'trx' => $trx
		);
		

		return $return;
	}

	function get_customer($class = '', $id = '', $parent = 'idoutlet') {
		$ci =& get_instance();

		$ci->load->library('AZApp');
		$ci->load->helper('az_core');
		$azapp = $ci->azapp;

		$crud = $azapp->add_crud();

		$crud->add_aodata('idoutlet', $parent);

		$crud->set_column(array('No', azlang('Code'), azlang('Name'), azlang('Address'), azlang('Email'), azlang('Phone'), azlang('Action')));
		$crud->set_id("customer");
		$crud->set_url("app_url+'data_customer/get_data_customer'");
		$crud->set_url_edit("app_url+'data_customer/edit_data_customer'");
		$crud->set_url_save("app_url+'data_customer/save_data_customer'");
		$crud->set_url_delete("app_url+'data_customer/delete_data_customer'");
		$crud->set_width(',,,,,80px');

		$crud->set_btn_add(false);

		$crud = $crud->render();

		$modal = $azapp->add_modal();
		$modal->set_id('lcustomer');
		$modal->set_modal_title('Member');
		$modal->set_modal($crud);
		$ret = $modal->render();

		$the_id = 'idcustomer';
		if (strlen($id) > 0) {
			$the_id = $id.'.'.$the_id;
		}

		$ci->load->library('encrypt');

		$data['data_id'] = $ci->encrypt->encode($the_id);
		$data['data_class'] = $class;

		$txt = $ci->load->view('lcustomer/v_lcustomer', $data, true);

		$js = az_add_js('lcustomer/vjs_lcustomer');
		$azapp->add_js($js);

		$ret .= $txt;

		return $ret;
	}

}