<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pick_up extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('pick_up');
        $this->table = 'transaction_group';
        $this->controller = 'pick_up';
        $this->load->helper('az_crud');
        $this->load->helper('az_config');
    }

    function index() {
    	$this->load->library('AZApp');
    	$app = $this->azapp;

    	$crud = $app->add_crud();

		$crud->set_column(array('#', 'No Bill', 'Status', 'Pelanggan', 'Tgl Transaksi', 'Tgl Pickup', 'Hal Pembayaran', azlang('Total'), azlang('Action')));
		$crud->set_id($this->controller);
		$crud->set_default_url(true);
		$crud->set_single_filter(false);
		// $crud->set_width(',,,,,,,,,,230px');

        $crud->set_btn_add(false);
		$crud->add_aodata('idcustomer', 'idcustomer');
		$role = $this->session->userdata('role_name');
		if ($role == 'cashier') {
			$crud->add_aodata_static('iDisplayLength', '5');			
		}

		$crud = $crud->render();

		$view = $this->load->view('pick_up/v_filter_pick_up', '', true);
		$app->add_content($view);
		$app->add_content($crud);	

		$app->add_content("<div class='container-scanner hide'><button class='btn btn-danger btn-sm btn-close-scanner' type='button'>".azlang('Close')."</button><br><video class='scanner' id='scanner'></video></div>");


		$btn_modal = array(
			'pickup' => "<i class='fa fa-print'></i> Pick Up",
		);
		$modal_detail = $app->add_modal();
		$modal_detail->set_id('detail');
		$modal_detail->set_modal_title(azlang('Detail'));
		$modal_detail->set_modal("<div class='container-detail'></div>");
		$modal_detail->set_action_modal($btn_modal);
		$app->add_content($modal_detail->render());

		$this->load->helper('az_core');
		$js = az_add_js('pick_up/vjs_pick_up');
		$app->add_js($js);

		$param['type'] = 'pickup';
		$js = az_add_js('js/vjs_act_scanner', $param);
		$app->add_js($js);

    	$data_header['title'] = 'Pick Up';
		$data_header['breadcrumb'] = array('pick_up');
		$app->set_data_header($data_header);
    	echo $app->render();
    }

    public function get() {
		$this->load->library('AZApp');
		$crud = $this->azapp->add_crud();
		$idcustomer = $this->input->get('idcustomer');
		// if (strlen($idcustomer) > 0) {
			$crud->add_where("transaction_group.idcustomer = '".$idcustomer."'");
		// }

		$idoutlet = $this->session->userdata('idoutlet');
		if (strlen($idoutlet) > 0) {
			$crud->add_where("transaction_group.idoutlet = '".$idoutlet."'");
		}

		// $crud->add_where("transaction_group_status = 'Pick Up'");
		$crud->set_select("idtransaction_group, code, dstb_status, customer_name, date_format(date, '%d-%m-%Y %H:%i:%s') as date, date_format(pickup_date, '%d-%m-%Y %H:%i:%s') as pickup_date, payment_status, grand_total_final");
		$crud->set_select_table("idtransaction_group, code, dstb_status, customer_name, date, pickup_date, payment_status, grand_total_final");
		$crud->set_sorting('code, dstb_status, customer_name, date, pickup_date, payment_status, grand_total_final');
		$crud->set_id($this->controller);
		
		$crud->set_group_by('transaction_group.idtransaction_group');
		$crud->add_join('customer', 'left');
		$crud->set_select_align(',,,,,,right');
		$crud->set_select_decimal('6');
		$crud->add_where("transaction_group.status > 0");
		$crud->set_table($this->table);
		$crud->set_order_by("transaction_group.created desc");
		$crud->set_custom_style('custom_style');
		echo $crud->get_table();
	}

	function custom_style($key, $value, $data) {
		$idtransaction_group = azarr($data, 'idtransaction_group');
		if ($key == 'action') {
			$code = azarr($data, 'code');
			$btn = "<button data-code='".$code."' class='btn btn-info btn-detail btn-xs' type='button'><i class='fa fa-file-o'></i> ".azlang('Detail')."</button>";

			return $btn;
		}
		return $value;
	}

	function get_invoice() {
		$this->load->helper('az_core');
		$code = $this->input->post('code');
		$this->load->library('Laundry');
		$data = $this->laundry->invoice($code);

		$err_code = azarr($data, 'err_code');
		$err_message = azarr($data, 'err_message');

		$this->load->helper('az_config');
		$view = $this->load->view('pick_up/v_invoice', $data, true);

		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message,
			'data' => $view
		);

		echo json_encode($return);
	}

	function get_detail() {
		$code = $this->input->post('code');
		$err_code = 0;
		$err_message = '';
		$data = '';

		$this->load->library('Laundry');
		$rdata = $this->laundry->invoice($code);
		$err_code = azarr($rdata, 'err_code');
		$err_message = azarr($rdata, 'err_message');
		$is_hide_btn = false;

		if ($err_code == 0) {
			$view = $this->load->view('sales_transaction/v_invoice', $rdata, true);

			$this->db->where('status', 1);
			$rdata['payment'] = $this->db->get('payment_type');

			$view_pay = $this->load->view('pick_up/v_payment', $rdata, true);	


			$stat = azarr($rdata, 'data');
			$stat = azarr($stat, 'dstb_status');
			if ($stat == 'SELESAI') {
				$is_hide_btn = true;
			}
			

			$data = $view;
			$data .= $view_pay;
		}


		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message,
			'data' => $data,
			'is_hide_btn' => $is_hide_btn
		);
		echo json_encode($return);
	}

	function process(){
		$err_code = 0;
		$err_message = '';
		$this->load->helper('az_crud');

		$idtransaction_group = $this->input->post('idtransaction_group');
		$idpayment_type_finish = $this->input->post('idpayment_type_finish');

		$this->db->where('idtransaction_group', $idtransaction_group);
		$trx = $this->db->get('transaction_group');

		$total_pay = $this->input->post('total_pay');
		$total_pay = az_crud_number($total_pay);

		if ($idpayment_type_finish != 1) {
			$total_pay = $trx->row()->grand_total_final;
		}

		$payment_status = $trx->row()->payment_status;

		$is_pay = true;
		if ($trx->row()->payment_status == 'CASH') {
			$is_pay = false;
		}

		if (strlen($total_pay) == 0 && $is_pay) {
			$err_code++;
			$err_message = 'Harap isi Jumlah Bayar';
		}

		if ($err_code == 0) {
			if (strlen($idpayment_type_finish) == 0 && $is_pay) {
				$err_code++;
				$err_message = 'Harap isi jenis pembayaran';
			}
		}

		if ($err_code == 0) {
			$pay = $trx->row()->grand_total_final;
			if ($trx->row()->payment_status == 'PANJAR') {
				$pay = $pay - $trx->row()->total_panjar;
			}

			if ($total_pay < $pay && $is_pay) {
				$err_code++;
				$err_message = 'Jumlah uang kurang';
			}
		}

		if ($err_code == 0) {
			$arr_money = array(
				'idpickup' => $this->session->userdata('iduser'),
				'transaction_group_status' => 'Selesai',
				'dstb_status' => 'SELESAI',
				'pickup_date' => Date('Y-m-d H:i:s')
			);

			if ($trx->row()->payment_status != 'CASH') {
				$arr_money['total_pay_finish'] = $pay;
				$arr_money['idpayment_type_finish'] = $idpayment_type_finish;
			}

			az_crud_save($idtransaction_group, 'transaction_group', $arr_money);
		}

		$return = array(
			'err_code' => $err_code,
			'err_message' => $err_message
		);
		echo json_encode($return);
	}
}