<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cash_report extends CI_Controller {
	public function __construct() {
        parent::__construct();

        $this->load->helper('az_auth');
        az_check_auth('cash_report');

        $this->load->helper('az_crud');
        $this->load->library('AZApp');
        $this->crud = $this->azapp->add_crud();
    }

	public function index(){
		$azapp = $this->azapp;
		$data_header['title'] = "Laporan Kas";
		$data_header['breadcrumb'] = array('report', 'cash_report');
		$azapp->set_data_header($data_header);

		$datetime1 = $azapp->add_datetime();
		$datetime1->set_id("date_1");
		$datetime1->set_name("date_1");
		$datetime1->set_value(Date("d-m-Y"));
		$datetime1->set_format("DD-MM-YYYY");
		$data['datetime1'] = $datetime1->render();

		$datetime2 = $azapp->add_datetime();
		$datetime2->set_id("date_2");
		$datetime2->set_name("date_2");
		$datetime2->set_value(Date("d-m-Y"));
		$datetime2->set_format("DD-MM-YYYY");
		$data['datetime2'] = $datetime2->render();

		$this->load->helper('az_core');
		$js = az_add_js('cash_report/vjs_cash_report');
		$azapp->add_js($js);

		$view = $this->load->view('cash_report/v_cash_report', $data, true);
		$azapp->add_content($view);
		
		echo $azapp->render();	
	}

	function get_cash_report() {
		$this->load->helper('az_core');
		$date_1 = $this->input->post('date_1');
		$date_2 = $this->input->post('date_2');

		$date_1 = Date('Y-m-d', strtotime($date_1));
		$date_2 = Date('Y-m-d', strtotime($date_2));

		$idcashier = $this->input->post("idcashier");
		
		$idoutlet = $this->input->post('idoutlet');
		$sess_idoutlet = $this->session->userdata('idoutlet');
		if (strlen($sess_idoutlet) > 0) {
			$idoutlet = $sess_idoutlet;
		}

		$this->db->where('status', 1);
		$payment_type = $this->db->get('payment_type');
		$arr_data = array();
		$grand_total = 0;
		foreach ($payment_type->result() as $key => $value) {
			if (strlen($idoutlet) > 0) {
				$this->db->where('transaction_group.idoutlet', $idoutlet);
			}
			if (strlen($idcashier) > 0) {
				$this->db->where('transaction_group.iduser', $idcashier);
			}
			$this->db->where('idpayment_type', $value->idpayment_type);
			$this->db->where('transaction_group.status', 1);
			$this->db->where('date(date) >=', $date_1);
			$this->db->where('date(date) <=', $date_2);
			$this->db->join('customer', 'transaction_group.idcustomer = customer.idcustomer');
			$this->db->join('user', 'transaction_group.iduser = user.iduser');
			$this->db->join('outlet', 'transaction_group.idoutlet = outlet.idoutlet');
			$this->db->select('*, transaction_group.idoutlet');
			$trx = $this->db->get('transaction_group');

			$arr = array();
			$total = 0;
			foreach ($trx->result() as $trx_key => $trx_value) {
				$total_pay = $trx_value->grand_total_final;
				$payment_status = $trx_value->payment_status;
				if ($trx_value->payment_status == 'PANJAR') {
					$total_pay = $trx_value->total_panjar;
				}
				else if ($trx_value->payment_status == 'BELUM BAYAR') {
					$total_pay = 0;
					$payment_status = 'NOPAY';
				}
				$arr[] = array(
					'date' => $trx_value->date,
					'outlet_name' => $trx_value->outlet_name,
					'nobill' => $trx_value->code,
					'customer' => $trx_value->customer_name,
					'total' => $total_pay,
				);

				$total += $total_pay;
			}

			//pickup
			if (strlen($idoutlet) > 0) {
				$this->db->where('transaction_group.idoutlet', $idoutlet);
			}
			if (strlen($idcashier) > 0) {
				$this->db->where('transaction_group.iduser', $idcashier);
			}
			$this->db->where('idpayment_type_finish', $value->idpayment_type);
			$this->db->where('date(pickup_date) >=', $date_1);
			$this->db->where('date(pickup_date) <=', $date_2);
			$this->db->where('transaction_group_status', 'Selesai');
			$this->db->join('customer', 'transaction_group.idcustomer = customer.idcustomer');
			$this->db->join('outlet', 'transaction_group.idoutlet = outlet.idoutlet');
			$this->db->where('transaction_group.status', 1);
			$this->db->join('user', 'transaction_group.iduser = user.iduser');
			$this->db->select('*, transaction_group.idoutlet');
			$trx = $this->db->get('transaction_group');

			foreach ($trx->result() as $trx_key => $trx_value) {
				$total_pay = $trx_value->grand_total_final;
				$payment_status = $trx_value->payment_status;
				if ($trx_value->payment_status == 'PANJAR') {
					$total_pay = $trx_value->grand_total_final - $trx_value->total_panjar;
					$payment_status = 'LUNAS PANJAR Rp '.az_thousand_separator($trx_value->total_panjar);
				}
				else if ($trx_value->payment_status == 'BELUM BAYAR') {
					$total_pay = $trx_value->grand_total_final;
					$payment_status = 'PELUNASAN';
				}
				else if ($trx_value->payment_status == 'CASH') {
					$total_pay = 0;
					$payment_status = 'PAID';
				}

				$arr[] = array(
					'date' => $trx_value->pickup_date,
					'outlet_name' => $trx_value->outlet_name,
					'nobill' => $trx_value->code,
					'customer' => $trx_value->customer_name,
					'total' => $total_pay,
				);

				$total += $total_pay;
			}

			$grand_total += $total;

			$arr_data[] = array(
				'payment' => $value->payment_type_name,
				'list' => $arr,
				'total' => $total
			);
		}

		$rdata_payment['data'] = $arr_data;
		$rdata_payment['grand_total'] = $grand_total;
		$table_payment = $this->load->view('cash_report/v_table_payment', $rdata_payment, true);

		$result = array(
			'table_payment' => $table_payment,
		);

		echo json_encode($result);
	
	}
}